<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class EmailVerificationPromptController extends Controller
{
    /**
     * Display the email verification prompt.
     */
    public function __invoke(Request $request): RedirectResponse|View
    {
        if ($request->user()->hasVerifiedEmail()) {
            // Direct redirect based on user role
            if ($request->user()->is_admin) {
                return redirect('/admin/dashboard');
            }
            return redirect('/account/dashboard');
        }

        return view('auth.verify-email');
    }
}