<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;
use PDF;

class InvoiceController extends Controller
{
    public function download($orderNumber)
    {
        $order = Order::with(['items.product', 'shippingAddress', 'user'])
            ->where('order_number', $orderNumber)
            ->firstOrFail();

        // Check authorization
        if ($order->user_id && $order->user_id !== auth()->id() && !auth()->user()->is_admin) {
            abort(403);
        }

        $companyInfo = \App\Models\CompanyInfo::first();
        
        // Get tax rate details for the order's shipping location
        $taxRate = null;
        if ($order->shippingAddress) {
            $taxRate = \App\Models\TaxRate::findByCity(
                $order->shippingAddress->city,
                $order->shippingAddress->state
            );
        }

        $pdf = PDF::loadView('invoices.order', compact('order', 'companyInfo', 'taxRate'));
        
        return $pdf->download('invoice-' . $order->order_number . '.pdf');
    }

    public function view($orderNumber)
    {
        $order = Order::with(['items.product', 'shippingAddress', 'user'])
            ->where('order_number', $orderNumber)
            ->firstOrFail();

        // Check authorization
        if ($order->user_id && $order->user_id !== auth()->id() && !auth()->user()->is_admin) {
            abort(403);
        }

        $companyInfo = \App\Models\CompanyInfo::first();
        
        // Get tax rate details for the order's shipping location
        $taxRate = null;
        if ($order->shippingAddress) {
            $taxRate = \App\Models\TaxRate::findByCity(
                $order->shippingAddress->city,
                $order->shippingAddress->state
            );
        }

        return view('invoices.order', compact('order', 'companyInfo', 'taxRate'));
    }
}