<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Category;

class LookbookController extends Controller
{
    /**
     * Lookbook main page
     */
    public function index()
    {
        $lookbooks = [
            [
                'title' => 'Street Culture Collection',
                'slug' => 'street-culture',
                'description' => 'Urban streetwear meets cultural heritage in our signature collection',
                'image' => 'lookbooks/street-culture.jpg',
                'products' => Product::where('is_featured', true)->limit(6)->get()
            ],
            [
                'title' => 'Punjabi Fusion Essentials',
                'slug' => 'punjabi-fusion',
                'description' => 'Traditional Punjabi elements reimagined for modern streetwear',
                'image' => 'lookbooks/punjabi-fusion.jpg',
                'products' => Product::where('is_active', true)->inRandomOrder()->limit(6)->get()
            ],
            [
                'title' => 'Sustainable Style Edit',
                'slug' => 'sustainable-style',
                'description' => 'Eco-conscious fashion choices that don\'t compromise on style',
                'image' => 'lookbooks/sustainable-style.jpg',
                'products' => Product::where('is_active', true)->limit(6)->get()
            ],
            [
                'title' => 'Australian Streetwear Icons',
                'slug' => 'australian-icons',
                'description' => 'Celebrating Australian street culture through fashion',
                'image' => 'lookbooks/australian-icons.jpg',
                'products' => Product::where('is_featured', true)->limit(6)->get()
            ]
        ];

        return view('lookbook.index', compact('lookbooks'));
    }

    /**
     * Individual lookbook page
     */
    public function show($slug)
    {
        $lookbooks = [
            'street-culture' => [
                'title' => 'Street Culture Collection',
                'description' => 'Urban streetwear meets cultural heritage in our signature collection',
                'meta_title' => 'Street Culture Collection | Edition By Punjab Lookbook',
                'meta_description' => 'Explore our Street Culture Collection featuring urban streetwear that blends cultural heritage with contemporary style. Australian streetwear with meaning.',
                'keywords' => 'street culture, urban streetwear, cultural fashion, streetwear collection, edition by punjab',
                'image' => 'lookbooks/street-culture-hero.jpg',
                'content' => $this->getStreetCultureContent(),
                'products' => Product::where('is_featured', true)->limit(8)->get()
            ],
            'punjabi-fusion' => [
                'title' => 'Punjabi Fusion Essentials',
                'description' => 'Traditional Punjabi elements reimagined for modern streetwear',
                'meta_title' => 'Punjabi Fusion Streetwear Collection | Cultural Fashion Australia',
                'meta_description' => 'Discover our Punjabi Fusion collection where traditional heritage meets modern streetwear. Authentic cultural fashion designed in Australia.',
                'keywords' => 'punjabi fusion, cultural streetwear, heritage fashion, traditional meets modern, punjabi clothing australia',
                'image' => 'lookbooks/punjabi-fusion-hero.jpg',
                'content' => $this->getPunjabiFusionContent(),
                'products' => Product::where('is_active', true)->inRandomOrder()->limit(8)->get()
            ],
            'sustainable-style' => [
                'title' => 'Sustainable Style Edit',
                'description' => 'Eco-conscious fashion choices that don\'t compromise on style',
                'meta_title' => 'Sustainable Streetwear Collection | Eco-Friendly Fashion Australia',
                'meta_description' => 'Shop our sustainable streetwear collection featuring eco-friendly materials and ethical production. Sustainable fashion that looks good and does good.',
                'keywords' => 'sustainable streetwear, eco fashion, ethical clothing, sustainable fashion australia, green streetwear',
                'image' => 'lookbooks/sustainable-hero.jpg',
                'content' => $this->getSustainableContent(),
                'products' => Product::where('is_active', true)->limit(8)->get()
            ],
            'australian-icons' => [
                'title' => 'Australian Streetwear Icons',
                'description' => 'Celebrating Australian street culture through fashion',
                'meta_title' => 'Australian Streetwear Icons | Local Street Culture Fashion',
                'meta_description' => 'Celebrate Australian street culture with our iconic collection. Local streetwear that represents the diverse and vibrant Australian fashion scene.',
                'keywords' => 'australian streetwear, local fashion, street culture australia, australian fashion icons, local streetwear brands',
                'image' => 'lookbooks/australian-icons-hero.jpg',
                'content' => $this->getAustralianIconsContent(),
                'products' => Product::where('is_featured', true)->limit(8)->get()
            ]
        ];

        $lookbook = $lookbooks[$slug] ?? abort(404);

        return view('lookbook.show', compact('lookbook', 'slug'));
    }

    private function getStreetCultureContent()
    {
        return '<h2>Where Urban Meets Heritage</h2>
        
        <p>Our Street Culture Collection represents the perfect fusion of contemporary urban style and rich cultural heritage. Each piece tells a story of identity, belonging, and creative expression through fashion.</p>
        
        <h3>Collection Highlights</h3>
        
        <div class="row">
            <div class="col-md-6">
                <h4>Cultural Graphics</h4>
                <p>Bold graphics that celebrate Punjabi heritage while speaking to modern street culture. Our designs feature traditional motifs reimagined for contemporary wear.</p>
            </div>
            <div class="col-md-6">
                <h4>Premium Materials</h4>
                <p>High-quality fabrics chosen for comfort, durability, and style. We believe in creating pieces that last, both in terms of fashion and physical longevity.</p>
            </div>
        </div>
        
        <h3>Styling Tips</h3>
        
        <ul>
            <li><strong>Layer with Confidence:</strong> Mix our cultural pieces with neutral basics for versatile looks</li>
            <li><strong>Statement Pieces:</strong> Let one cultural element be the focal point of your outfit</li>
            <li><strong>Color Coordination:</strong> Use traditional color palettes as inspiration for your styling</li>
            <li><strong>Occasion Versatility:</strong> Our pieces transition from casual to elevated with the right styling</li>
        </ul>';
    }

    private function getPunjabiFusionContent()
    {
        return '<h2>Traditional Heritage Meets Modern Style</h2>
        
        <p>The Punjabi Fusion Essentials collection celebrates the rich textile traditions and vibrant culture of Punjab, thoughtfully integrated into contemporary streetwear silhouettes.</p>
        
        <h3>Design Philosophy</h3>
        
        <p>Every piece in this collection honors the craftsmanship and symbolism of traditional Punjabi textiles while ensuring modern wearability and style relevance.</p>
        
        <div class="row">
            <div class="col-md-4">
                <h4>Phulkari Inspiration</h4>
                <p>Traditional embroidery patterns reinterpreted through modern design techniques and contemporary color palettes.</p>
            </div>
            <div class="col-md-4">
                <h4>Cultural Colors</h4>
                <p>Rich, meaningful colors that carry cultural significance while appealing to modern aesthetic preferences.</p>
            </div>
            <div class="col-md-4">
                <h4>Heritage Typography</h4>
                <p>Gurmukhi script and traditional calligraphy elements integrated into modern graphic design layouts.</p>
            </div>
        </div>
        
        <h3>How to Wear</h3>
        
        <p>Our Punjabi Fusion pieces are designed to be worn with pride and confidence. Pair our heritage hoodies with contemporary denim, or style our cultural tees with modern outerwear for a look that bridges generations.</p>';
    }

    private function getSustainableContent()
    {
        return '<h2>Fashion with a Conscience</h2>
        
        <p>The Sustainable Style Edit proves that eco-conscious choices don\'t mean compromising on style. Every piece in this collection is carefully selected for its environmental impact and style quotient.</p>
        
        <h3>Our Sustainability Commitments</h3>
        
        <div class="row">
            <div class="col-md-6">
                <h4>Eco-Friendly Materials</h4>
                <ul>
                    <li>Organic cotton grown without harmful pesticides</li>
                    <li>Recycled polyester from post-consumer plastic bottles</li>
                    <li>Hemp fibers for natural durability and comfort</li>
                    <li>Low-impact dyes and printing processes</li>
                </ul>
            </div>
            <div class="col-md-6">
                <h4>Ethical Production</h4>
                <ul>
                    <li>Fair labor practices throughout our supply chain</li>
                    <li>Local manufacturing to reduce carbon footprint</li>
                    <li>Small batch production to minimize waste</li>
                    <li>Transparent sourcing and production processes</li>
                </ul>
            </div>
        </div>
        
        <h3>Style Tips for Sustainable Fashion</h3>
        
        <p>Building a sustainable wardrobe is about making intentional choices. Invest in quality pieces that you\'ll love for years, learn to care for your clothes properly, and embrace the beauty of wearing items that align with your values.</p>';
    }

    private function getAustralianIconsContent()
    {
        return '<h2>Celebrating Australian Street Culture</h2>
        
        <p>The Australian Streetwear Icons collection pays homage to the diverse and vibrant street culture that defines Australian fashion. From Melbourne\'s creative laneways to Sydney\'s coastal cool, this collection captures the essence of Australian style.</p>
        
        <h3>Regional Style Influences</h3>
        
        <div class="row">
            <div class="col-md-4">
                <h4>Melbourne Creative</h4>
                <p>Artistic, layered, and experimental. Melbourne\'s fashion scene inspires pieces that embrace creativity and individual expression.</p>
            </div>
            <div class="col-md-4">
                <h4>Sydney Coastal</h4>
                <p>Relaxed yet refined. Sydney\'s beach-to-city lifestyle influences versatile pieces that transition seamlessly between environments.</p>
            </div>
            <div class="col-md-4">
                <h4>Brisbane Tropical</h4>
                <p>Breathable and bright. Queensland\'s tropical climate inspires lightweight pieces with vibrant accents and sun-smart design.</p>
            </div>
        </div>
        
        <h3>What Makes Australian Streetwear Unique</h3>
        
        <p>Australian streetwear is defined by its inclusivity, creativity, and connection to the diverse cultures that call Australia home. Our collection celebrates this multicultural influence while staying true to the laid-back Australian spirit.</p>';
    }
}