<?php

namespace App\Mail;

use App\Models\NewsletterSubscriber;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewsletterWelcome extends Mailable
{
    use Queueable, SerializesModels;

    public $subscriber;
    public $discountCode;

    public function __construct(NewsletterSubscriber $subscriber, $discountCode)
    {
        $this->subscriber = $subscriber;
        $this->discountCode = $discountCode;
    }

    public function build()
    {
        return $this->subject('Welcome! Here\'s Your 10% Discount Code')
                    ->view('emails.newsletter-welcome');
    }
}