<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Blade;
use App\Helpers\ImageHelper;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Make ImageHelper available in all views
        View::share('ImageHelper', ImageHelper::class);
        
        // Create a Blade directive for easy image URL generation
        Blade::directive('imageUrl', function ($expression) {
            return "<?php echo \App\Helpers\ImageHelper::getImageUrl($expression); ?>";
        });
        
        // Create a Blade directive for gallery images
        Blade::directive('galleryImages', function ($expression) {
            return "<?php echo json_encode(\App\Helpers\ImageHelper::getGalleryImages($expression)); ?>";
        });
        
        // Fix HTTPS in production
        if (config('app.env') === 'production') {
            \URL::forceScheme('https');
        }
    }
}