<?php
// app/Traits/AuthRedirects.php

namespace App\Traits;

use Illuminate\Support\Facades\Auth;

trait AuthRedirects
{
    /**
     * Get the post-authentication redirect path based on user role.
     *
     * @return string
     */
    protected function redirectTo(): string
    {
        if (Auth::check()) {
            return Auth::user()->is_admin ? '/admin/dashboard' : '/account/dashboard';
        }
        
        return '/';
    }
    
    /**
     * Get the intended redirect path for a specific user.
     *
     * @param  \App\Models\User  $user
     * @return string
     */
    protected function getRedirectPath($user): string
    {
        return $user->is_admin ? '/admin/dashboard' : '/account/dashboard';
    }
}