<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class LazyImage extends Component
{
    public $src;
    public $alt;
    public $class;
    public $style;

    /**
     * Create a new component instance.
     */
    public function __construct($src, $alt = '', $class = '', $style = '')
    {
        $this->src = $src;
        $this->alt = $alt;
        $this->class = $class;
        $this->style = $style;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.lazy-image');
    }

    /**
     * Get the processed image URL
     */
    public function getImageUrl()
    {
        // Use the existing ImageHelper if available, otherwise return the src
        if (class_exists('\App\Helpers\ImageHelper')) {
            return \App\Helpers\ImageHelper::getImageUrl($this->src);
        }
        
        // Fallback for asset URLs
        if (str_starts_with($this->src, 'http')) {
            return $this->src;
        }
        
        return asset('images/' . $this->src);
    }
}
