<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShippingZonesTable extends Migration
{
    public function up()
    {
        Schema::create('shipping_zones', function (Blueprint $table) {
            $table->id();
            $table->string('city');
            $table->string('state');
            $table->string('postcode_range')->nullable(); // e.g., "2000-2999"
            $table->decimal('standard_rate', 10, 2)->default(10.00);
            $table->decimal('express_rate', 10, 2)->default(15.00);
            $table->decimal('priority_rate', 10, 2)->default(25.00);
            $table->decimal('free_shipping_threshold', 10, 2)->nullable(); // null means no free shipping
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
            
            $table->index(['city', 'state']);
            $table->index('is_active');
        });
        
        // Add default shipping zones for major Australian cities
        DB::table('shipping_zones')->insert([
            // New South Wales
            ['city' => 'Sydney', 'state' => 'NSW', 'postcode_range' => '2000-2999', 'standard_rate' => 0, 'express_rate' => 10, 'priority_rate' => 20, 'free_shipping_threshold' => 50, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Newcastle', 'state' => 'NSW', 'postcode_range' => '2300-2399', 'standard_rate' => 10, 'express_rate' => 15, 'priority_rate' => 25, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Wollongong', 'state' => 'NSW', 'postcode_range' => '2500-2599', 'standard_rate' => 10, 'express_rate' => 15, 'priority_rate' => 25, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Victoria
            ['city' => 'Melbourne', 'state' => 'VIC', 'postcode_range' => '3000-3999', 'standard_rate' => 0, 'express_rate' => 10, 'priority_rate' => 20, 'free_shipping_threshold' => 50, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Geelong', 'state' => 'VIC', 'postcode_range' => '3200-3299', 'standard_rate' => 12, 'express_rate' => 18, 'priority_rate' => 28, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Ballarat', 'state' => 'VIC', 'postcode_range' => '3350-3399', 'standard_rate' => 15, 'express_rate' => 20, 'priority_rate' => 30, 'free_shipping_threshold' => 150, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Queensland
            ['city' => 'Brisbane', 'state' => 'QLD', 'postcode_range' => '4000-4999', 'standard_rate' => 0, 'express_rate' => 10, 'priority_rate' => 20, 'free_shipping_threshold' => 50, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Gold Coast', 'state' => 'QLD', 'postcode_range' => '4200-4299', 'standard_rate' => 10, 'express_rate' => 15, 'priority_rate' => 25, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Cairns', 'state' => 'QLD', 'postcode_range' => '4870-4899', 'standard_rate' => 20, 'express_rate' => 30, 'priority_rate' => 40, 'free_shipping_threshold' => 200, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Western Australia
            ['city' => 'Perth', 'state' => 'WA', 'postcode_range' => '6000-6999', 'standard_rate' => 15, 'express_rate' => 25, 'priority_rate' => 35, 'free_shipping_threshold' => 150, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Fremantle', 'state' => 'WA', 'postcode_range' => '6160-6169', 'standard_rate' => 15, 'express_rate' => 25, 'priority_rate' => 35, 'free_shipping_threshold' => 150, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // South Australia
            ['city' => 'Adelaide', 'state' => 'SA', 'postcode_range' => '5000-5999', 'standard_rate' => 12, 'express_rate' => 20, 'priority_rate' => 30, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Tasmania
            ['city' => 'Hobart', 'state' => 'TAS', 'postcode_range' => '7000-7999', 'standard_rate' => 18, 'express_rate' => 28, 'priority_rate' => 38, 'free_shipping_threshold' => 150, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            ['city' => 'Launceston', 'state' => 'TAS', 'postcode_range' => '7250-7299', 'standard_rate' => 20, 'express_rate' => 30, 'priority_rate' => 40, 'free_shipping_threshold' => 150, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Northern Territory
            ['city' => 'Darwin', 'state' => 'NT', 'postcode_range' => '0800-0899', 'standard_rate' => 25, 'express_rate' => 35, 'priority_rate' => 45, 'free_shipping_threshold' => 200, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Australian Capital Territory
            ['city' => 'Canberra', 'state' => 'ACT', 'postcode_range' => '2600-2699', 'standard_rate' => 10, 'express_rate' => 15, 'priority_rate' => 25, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
            
            // Default for other areas
            ['city' => 'Other', 'state' => 'ALL', 'postcode_range' => null, 'standard_rate' => 15, 'express_rate' => 25, 'priority_rate' => 35, 'free_shipping_threshold' => 100, 'is_active' => true, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    public function down()
    {
        Schema::dropIfExists('shipping_zones');
    }
}