<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('tracking_number')->nullable()->after('order_number');
            $table->text('tracking_updates')->nullable();
            $table->string('carrier')->nullable();
            $table->string('estimated_delivery')->nullable();
            $table->index('tracking_number');
        });
    }

    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['tracking_number', 'tracking_updates', 'carrier', 'estimated_delivery']);
        });
    }
};