<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Add is_admin if it doesn't exist
            if (!Schema::hasColumn('users', 'is_admin')) {
                $table->boolean('is_admin')->default(false)->after('password');
            }
            
            // Add is_blocked if it doesn't exist
            if (!Schema::hasColumn('users', 'is_blocked')) {
                $table->boolean('is_blocked')->default(false)->after('is_admin');
            }
            
            // Add phone if it doesn't exist
            if (!Schema::hasColumn('users', 'phone')) {
                $table->string('phone')->nullable()->after('email');
            }
            
            // Add indexes for performance
            if (!Schema::hasIndex('users', 'users_is_admin_index')) {
                $table->index('is_admin');
            }
            
            if (!Schema::hasIndex('users', 'users_is_blocked_index')) {
                $table->index('is_blocked');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop indexes first
            if (Schema::hasIndex('users', 'users_is_blocked_index')) {
                $table->dropIndex('users_is_blocked_index');
            }
            
            if (Schema::hasIndex('users', 'users_is_admin_index')) {
                $table->dropIndex('users_is_admin_index');
            }
            
            // Drop columns
            if (Schema::hasColumn('users', 'is_blocked')) {
                $table->dropColumn('is_blocked');
            }
            
            if (Schema::hasColumn('users', 'is_admin')) {
                $table->dropColumn('is_admin');
            }
            
            if (Schema::hasColumn('users', 'phone')) {
                $table->dropColumn('phone');
            }
        });
    }
};