<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('style_guides', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->unique();
            $table->string('tagline');
            $table->text('description');
            $table->string('region');
            $table->string('population');
            $table->integer('fashion_score');
            $table->integer('streetwear_popularity');
            $table->text('meta_title');
            $table->text('meta_description');
            $table->text('keywords');
            $table->string('climate');
            $table->string('vibe');
            $table->string('hero_image')->nullable();
            $table->longText('content')->nullable();
            $table->json('styling_tips')->nullable();
            $table->json('style_characteristics')->nullable();
            $table->json('key_pieces')->nullable();
            $table->json('seasonal_styling')->nullable();
            $table->json('cultural_influences')->nullable();
            $table->json('color_palette')->nullable();
            $table->json('shopping_areas')->nullable();
            $table->json('weather')->nullable();
            $table->json('style_gallery')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('style_guides');
    }
};
