<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('discount_campaigns', function (Blueprint $table) {
            $table->boolean('is_seasonal')->default(false)->after('is_active');
            $table->boolean('show_timer')->default(false)->after('is_seasonal');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('discount_campaigns', function (Blueprint $table) {
            $table->dropColumn(['is_seasonal', 'show_timer']);
        });
    }
};
