<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update the position enum to include train_slider
        DB::statement("ALTER TABLE banners MODIFY COLUMN position ENUM('hero', 'promo_left', 'promo_right', 'home_hero_slider', 'below_categories_slider', 'train_slider') NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove train_slider from the enum
        DB::statement("ALTER TABLE banners MODIFY COLUMN position ENUM('hero', 'promo_left', 'promo_right', 'home_hero_slider', 'below_categories_slider') NOT NULL");
    }
};
