<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CommunityPage;

class CommunityPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'page_key' => 'community-index',
                'title' => 'Community Main Page',
                'content' => '<h2>Welcome to Our Community</h2><p>Join our vibrant community of fashion enthusiasts and share your style with the world. Discover authentic Punjabi-inspired streetwear and connect with like-minded individuals who celebrate culture through fashion.</p>',
                'meta_title' => 'Community - Edition By Punjab | Share Your Style',
                'meta_description' => 'Join the Edition By Punjab community. Share your style, discover cultural fashion, and connect with fellow streetwear enthusiasts.',
                'is_active' => true,
                'images' => []
            ],
            [
                'page_key' => 'community-gallery',
                'title' => 'Community Gallery',
                'content' => '<h2>Style Gallery</h2><p>Browse our community gallery featuring real customers showcasing their Edition By Punjab pieces. From street style to cultural celebrations, see how our community wears their heritage with pride.</p>',
                'meta_title' => 'Community Gallery - Style Inspiration | Edition By Punjab',
                'meta_description' => 'Browse our community gallery featuring real customers in Edition By Punjab streetwear. Get inspired by authentic cultural fashion.',
                'is_active' => true,
                'images' => []
            ],
            [
                'page_key' => 'community-spotlight',
                'title' => 'Customer Spotlight',
                'content' => '<h2>Community Spotlight</h2><p>Meet the inspiring individuals in our community. Each month, we highlight customers who embody the spirit of cultural pride and authentic style. Their stories showcase how fashion can be a powerful expression of identity.</p>',
                'meta_title' => 'Customer Spotlight - Community Stories | Edition By Punjab',
                'meta_description' => 'Meet inspiring customers who embody cultural pride and authentic style. Read their stories and fashion journeys.',
                'is_active' => true,
                'images' => []
            ],
            [
                'page_key' => 'community-submit',
                'title' => 'Submit Your Style',
                'content' => '<h2>Share Your Style</h2><p>Ready to be featured in our community? Submit your photos wearing Edition By Punjab pieces and share your story. We love celebrating the diversity and creativity of our community members.</p><div class="alert alert-info"><strong>Submission Guidelines:</strong><ul><li>Photos must feature Edition By Punjab products</li><li>High-quality images preferred</li><li>Include a brief story about your style</li><li>By submitting, you agree to potential feature use</li></ul></div>',
                'meta_title' => 'Submit Your Style - Be Featured | Edition By Punjab Community',
                'meta_description' => 'Share your Edition By Punjab style with our community. Submit photos and stories to be featured in our gallery.',
                'is_active' => true,
                'images' => []
            ]
        ];

        foreach ($pages as $pageData) {
            CommunityPage::updateOrCreate(
                ['page_key' => $pageData['page_key']],
                $pageData
            );
        }
    }
}
