@extends('layouts.app')

@section('title', 'My Account')
@section('meta_description', 'Manage your account, orders, and preferences')

@section('content')
<!-- Premium Account Hero -->
<section class="account-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-account" data-aos="fade-up">
            <h1 class="hero-title-account">MY ACCOUNT</h1>
            <p class="hero-subtitle-account">Welcome back, {{ $user->name }}</p>
        </div>
    </div>
</section>

<!-- Account Content -->
<section class="account-section-premium">
    <div class="container">
        <div class="row">
            <!-- Premium Sidebar -->
            <div class="col-lg-3" data-aos="fade-right">
                @include('account.sidebar')
            </div>
            
            <!-- Dashboard Content -->
            <div class="col-lg-9">
                <!-- Stats Cards -->
                <div class="stats-grid-premium" data-aos="fade-up">
                    <div class="stat-card-premium">
                        <div class="stat-icon-wrapper">
                            <i class="fas fa-shopping-bag"></i>
                        </div>
                        <div class="stat-content">
                            <h3 class="stat-value" data-count="{{ $stats['total_orders'] }}">0</h3>
                            <p class="stat-label">Total Orders</p>
                        </div>
                        <div class="stat-decoration"></div>
                    </div>
                    
                    <div class="stat-card-premium">
                        <div class="stat-icon-wrapper pending">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="stat-content">
                            <h3 class="stat-value" data-count="{{ $stats['pending_orders'] }}">0</h3>
                            <p class="stat-label">Pending Orders</p>
                        </div>
                        <div class="stat-decoration pending"></div>
                    </div>
                    
                    <div class="stat-card-premium">
                        <div class="stat-icon-wrapper wishlist">
                            <i class="fas fa-heart"></i>
                        </div>
                        <div class="stat-content">
                            <h3 class="stat-value" data-count="{{ $stats['wishlist_items'] }}">0</h3>
                            <p class="stat-label">Wishlist Items</p>
                        </div>
                        <div class="stat-decoration wishlist"></div>
                    </div>
                    
                    <div class="stat-card-premium">
                        <div class="stat-icon-wrapper addresses">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="stat-content">
                            <h3 class="stat-value" data-count="{{ $stats['addresses'] }}">0</h3>
                            <p class="stat-label">Saved Addresses</p>
                        </div>
                        <div class="stat-decoration addresses"></div>
                    </div>
                </div>
                
                <!-- Recent Orders -->
                <div class="orders-card-premium" data-aos="fade-up" data-aos-delay="100">
                    <div class="card-header-premium">
                        <h3 class="card-title-premium">
                            <span class="title-icon"><i class="fas fa-history"></i></span>
                            Recent Orders
                        </h3>
                        @if($recentOrders->count() > 0)
                        <a href="{{ route('account.orders') }}" class="view-all-link">
                            View All <i class="fas fa-arrow-right"></i>
                        </a>
                        @endif
                    </div>
                    
                    <div class="card-body-premium">
                        @if($recentOrders->count() > 0)
                        <div class="orders-table-wrapper">
                            <table class="premium-table">
                                <thead>
                                    <tr>
                                        <th>Order #</th>
                                        <th>Date</th>
                                        <th>Tax Rate</th>
                                        <th>Total</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentOrders as $order)
                                    <tr class="table-row-premium">
                                        <td>
                                            <span class="order-number">#{{ $order->order_number }}</span>
                                        </td>
                                        <td>
                                            <span class="order-date">{{ $order->created_at->format('M d, Y') }}</span>
                                        </td>
                                        <td>
                                            <span class="tax-rate-info">
                                                @if($order->taxRateInfo)
                                                    @if($order->taxRateInfo->rate == 0)
                                                        <span class="tax-free">{{ $order->taxRateInfo->tax_name }} 0%</span>
                                                    @else
                                                        {{ $order->taxRateInfo->tax_name }} {{ $order->taxRateInfo->rate }}%
                                                    @endif
                                                @else
                                                    GST 10%
                                                @endif
                                            </span>
                                        </td>
                                        <td>
                                            <span class="order-total">
                                                @if(isset($order->calculated_total_amount))
                                                    ${{ number_format($order->calculated_total_amount, 2) }}
                                                @else
                                                    ${{ number_format($order->total_amount, 2) }}
                                                @endif
                                            </span>
                                        </td>
                                        <td>
                                            <span class="status-badge {{ $order->status }}">
                                                {{ ucfirst($order->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('account.order.detail', $order->order_number) }}" 
                                               class="btn-action-premium">
                                                <span>View</span>
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="table-footer-premium">
                            <a href="{{ route('account.orders') }}" class="btn-view-all-premium">
                                VIEW ALL ORDERS
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                        @else
                        <div class="empty-state-premium">
                            <div class="empty-icon">
                                <i class="fas fa-shopping-bag"></i>
                            </div>
                            <h4>No orders yet</h4>
                            <p>Start shopping to see your orders here</p>
                            <a href="{{ route('shop.index') }}" class="btn-start-shopping">
                                START SHOPPING
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
                
                <!-- Quick Actions -->
                <div class="quick-actions-premium" data-aos="fade-up" data-aos-delay="200">
                    <h3 class="section-subtitle-premium">Quick Actions</h3>
                    <div class="actions-grid">
                        <a href="{{ route('account.profile') }}" class="action-card">
                            <i class="fas fa-user-edit"></i>
                            <span>Edit Profile</span>
                        </a>
                        <a href="{{ route('account.addresses') }}" class="action-card">
                            <i class="fas fa-plus-circle"></i>
                            <span>Add Address</span>
                        </a>
                        <a href="{{ route('shop.index') }}" class="action-card">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Continue Shopping</span>
                        </a>
                        <a href="{{ route('account.wishlist') }}" class="action-card">
                            <i class="fas fa-heart"></i>
                            <span>View Wishlist</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
/* Account Hero */
.account-hero-premium {
    height: 30vh;
    min-height: 250px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    overflow: hidden;
}

.account-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(255,255,255,.02) 35px,
        rgba(255,255,255,.02) 70px
    );
}

.hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: radial-gradient(circle at center, transparent 0%, rgba(0,0,0,0.4) 100%);
}

.hero-content-account {
    text-align: center;
    color: white;
    position: relative;
    z-index: 2;
}

.hero-title-account {
    font-size: clamp(2rem, 4vw, 3rem);
    font-weight: 900;
    letter-spacing: 0.1em;
    margin-bottom: 0.5rem;
    font-family: 'Space Grotesk', sans-serif;
}

.hero-subtitle-account {
    font-size: 1.125rem;
    opacity: 0.9;
}

/* Account Section */
.account-section-premium {
    padding: 4rem 0;
    background: #fafafa;
    min-height: 60vh;
}

/* Stats Grid */
.stats-grid-premium {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    margin-bottom: 3rem;
}

.stat-card-premium {
    background: white;
    padding: 1.5rem;
    position: relative;
    overflow: hidden;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: 1px solid #e0e0e0;
}

.stat-card-premium:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.1);
}

.stat-icon-wrapper {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
    margin-bottom: 1rem;
    transition: all 0.3s;
}

.stat-icon-wrapper.pending {
    background: linear-gradient(135deg, #FFB800 0%, #FF8A00 100%);
}

.stat-icon-wrapper.wishlist {
    background: linear-gradient(135deg, #FF3366 0%, #FF0066 100%);
}

.stat-icon-wrapper.addresses {
    background: linear-gradient(135deg, #00BCD4 0%, #0097A7 100%);
}

.stat-card-premium:hover .stat-icon-wrapper {
    transform: rotate(5deg) scale(1.1);
}

.stat-value {
    font-size: 2rem;
    font-weight: 900;
    color: #000;
    margin-bottom: 0.25rem;
    font-family: 'Space Grotesk', sans-serif;
}

.stat-label {
    font-size: 0.875rem;
    color: #666;
    letter-spacing: 0.05em;
}

.stat-decoration {
    position: absolute;
    top: -20px;
    right: -20px;
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, rgba(0,0,0,0.05) 0%, rgba(0,0,0,0.02) 100%);
    border-radius: 50%;
}

.stat-decoration.pending {
    background: linear-gradient(135deg, rgba(255,184,0,0.1) 0%, rgba(255,138,0,0.05) 100%);
}

.stat-decoration.wishlist {
    background: linear-gradient(135deg, rgba(255,51,102,0.1) 0%, rgba(255,0,102,0.05) 100%);
}

.stat-decoration.addresses {
    background: linear-gradient(135deg, rgba(0,188,212,0.1) 0%, rgba(0,151,167,0.05) 100%);
}

/* Orders Card */
.orders-card-premium {
    background: white;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    margin-bottom: 2rem;
    overflow: hidden;
}

.card-header-premium {
    padding: 1.5rem;
    background: linear-gradient(135deg, #fafafa 0%, #fff 100%);
    border-bottom: 2px solid #f0f0f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-title-premium {
    font-size: 1.25rem;
    font-weight: 700;
    color: #000;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0;
}

.title-icon {
    width: 35px;
    height: 35px;
    background: #000;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.875rem;
}

.view-all-link {
    color: #666;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s;
}

.view-all-link:hover {
    color: #000;
    transform: translateX(5px);
}

.card-body-premium {
    padding: 0;
}

/* Premium Table */
.orders-table-wrapper {
    overflow-x: auto;
}

.premium-table {
    width: 100%;
    border-collapse: collapse;
}

.premium-table thead {
    background: #fafafa;
}

.premium-table th {
    padding: 1rem 1.5rem;
    text-align: left;
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.1em;
    color: #666;
    text-transform: uppercase;
    border-bottom: 2px solid #f0f0f0;
}

.premium-table td {
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid #f0f0f0;
}

.table-row-premium {
    transition: all 0.3s;
}

.table-row-premium:hover {
    background: #fafafa;
}

.order-number {
    font-weight: 700;
    color: #000;
}

.order-date {
    color: #666;
}

.order-total {
    font-weight: 600;
    color: #000;
    font-size: 1rem;
}

.tax-rate-info {
    font-size: 0.875rem;
    font-weight: 600;
}

.tax-free {
    color: #28a745;
    font-weight: 700;
}

.status-badge {
    display: inline-block;
    padding: 0.375rem 0.875rem;
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    text-transform: uppercase;
    border-radius: 20px;
}

.status-badge.pending,
.status-badge.processing {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
    color: #856404;
}

.status-badge.shipped,
.status-badge.out_for_delivery {
    background: linear-gradient(135deg, #cce5ff 0%, #b8daff 100%);
    color: #004085;
}

.status-badge.delivered {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    color: #155724;
}

.status-badge.cancelled {
    background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
    color: #721c24;
}

.btn-action-premium {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 600;
    transition: all 0.3s;
}

.btn-action-premium:hover {
    background: #333;
    color: white;
    transform: translateY(-2px);
}

.table-footer-premium {
    padding: 1.5rem;
    text-align: center;
    background: #fafafa;
}

.btn-view-all-premium {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.875rem 2rem;
    background: white;
    color: #000;
    border: 2px solid #000;
    text-decoration: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-view-all-premium:hover {
    background: #000;
    color: white;
    transform: translateY(-2px);
}

/* Empty State */
.empty-state-premium {
    padding: 4rem 2rem;
    text-align: center;
}

.empty-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 1.5rem;
    background: linear-gradient(135deg, #f0f0f0 0%, #e0e0e0 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    color: #999;
}

.empty-state-premium h4 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    color: #333;
}

.empty-state-premium p {
    color: #666;
    margin-bottom: 2rem;
}

.btn-start-shopping {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 2rem;
    background: #000;
    color: white;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-start-shopping:hover {
    background: #333;
    color: white;
    transform: translateY(-2px);
}

/* Quick Actions */
.quick-actions-premium {
    margin-top: 2rem;
}

.section-subtitle-premium {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    color: #000;
}

.actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
}

.action-card {
    background: white;
    padding: 1.5rem;
    text-align: center;
    text-decoration: none;
    color: #333;
    border: 1px solid #e0e0e0;
    transition: all 0.3s;
}

.action-card:hover {
    background: #000;
    color: white;
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.action-card i {
    font-size: 1.5rem;
    display: block;
    margin-bottom: 0.75rem;
}

.action-card span {
    font-size: 0.875rem;
    font-weight: 600;
}

/* Responsive */
@media (max-width: 768px) {
    .stats-grid-premium {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .premium-table {
        font-size: 0.875rem;
    }
    
    .premium-table th,
    .premium-table td {
        padding: 0.75rem;
    }
    
    .actions-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}
</style>
@endpush

@push('scripts')
<script>
// Counter Animation
document.addEventListener('DOMContentLoaded', function() {
    const counters = document.querySelectorAll('.stat-value');
    const speed = 200;
    
    const animateCounter = (counter) => {
        const target = +counter.getAttribute('data-count');
        const increment = target / speed;
        
        let current = 0;
        const updateCounter = () => {
            current += increment;
            if (current < target) {
                counter.textContent = Math.ceil(current);
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target;
            }
        };
        updateCounter();
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                animateCounter(entry.target);
                observer.unobserve(entry.target);
            }
        });
    }, { threshold: 0.5 });
    
    counters.forEach(counter => observer.observe(counter));
});

// Table Row Hover Effect
document.querySelectorAll('.table-row-premium').forEach(row => {
    row.addEventListener('mouseenter', function() {
        this.style.transform = 'translateX(5px)';
    });
    
    row.addEventListener('mouseleave', function() {
        this.style.transform = 'translateX(0)';
    });
});
</script>
@endpush
@endsection