@extends('layouts.app')

@section('title', 'Profile Settings')
@section('meta_description', 'Manage your profile and account settings')

@section('content')
<!-- Premium Account Hero -->
<section class="account-hero-premium">
    <div class="hero-overlay"></div>
    <div class="container">
        <div class="hero-content-account" data-aos="fade-up">
            <h1 class="hero-title-account">PROFILE SETTINGS</h1>
            <p class="hero-subtitle-account">Manage your personal information</p>
        </div>
    </div>
</section>

<!-- Profile Content -->
<section class="account-section-premium">
    <div class="container">
        <div class="row">
            <!-- Premium Sidebar -->
            <div class="col-lg-3" data-aos="fade-right">
                @include('account.sidebar')
            </div>

            <!-- Profile Settings -->
            <div class="col-lg-9">
                @if(session('success'))
                <div class="alert-premium success" data-aos="fade-down">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('success') }}</span>
                    <button class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                @endif

                @if($errors->any())
                <div class="alert-premium error" data-aos="fade-down">
                    <i class="fas fa-exclamation-circle"></i>
                    <div>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <button class="alert-close" onclick="this.parentElement.remove()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                @endif

                <form action="{{ route('account.profile.update') }}" method="POST" class="profile-form-premium">
                    @csrf
                    @method('PUT')

                    <!-- Basic Information -->
                    <div class="profile-card-premium" data-aos="fade-up">
                        <div class="card-header-premium">
                            <h3 class="card-title-premium">
                                <span class="title-icon"><i class="fas fa-user"></i></span>
                                Basic Information
                            </h3>
                        </div>
                        
                        <div class="card-body-premium">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label for="name" class="form-label-premium">Full Name *</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-user"></i>
                                            <input type="text" 
                                                   class="form-control-premium @error('name') is-invalid @enderror" 
                                                   id="name" 
                                                   name="name" 
                                                   value="{{ old('name', $user->name) }}" 
                                                   required>
                                        </div>
                                        @error('name')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label for="email" class="form-label-premium">Email Address *</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-envelope"></i>
                                            <input type="email" 
                                                   class="form-control-premium @error('email') is-invalid @enderror" 
                                                   id="email" 
                                                   name="email" 
                                                   value="{{ old('email', $user->email) }}" 
                                                   required>
                                        </div>
                                        @error('email')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label for="phone" class="form-label-premium">Phone Number</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-phone"></i>
                                            <input type="tel" 
                                                   class="form-control-premium @error('phone') is-invalid @enderror" 
                                                   id="phone" 
                                                   name="phone" 
                                                   value="{{ old('phone', $user->phone) }}">
                                        </div>
                                        @error('phone')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label class="form-label-premium">Member Since</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-calendar"></i>
                                            <input type="text" 
                                                   class="form-control-premium" 
                                                   value="{{ $user->created_at->format('F d, Y') }}" 
                                                   readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Change Password -->
                    <div class="profile-card-premium" data-aos="fade-up" data-aos-delay="100">
                        <div class="card-header-premium">
                            <h3 class="card-title-premium">
                                <span class="title-icon"><i class="fas fa-lock"></i></span>
                                Change Password
                            </h3>
                        </div>
                        
                        <div class="card-body-premium">
                            <p class="section-note">
                                <i class="fas fa-info-circle"></i>
                                Leave blank if you don't want to change your password
                            </p>
                            
                            <div class="form-group-premium">
                                <label for="current_password" class="form-label-premium">Current Password</label>
                                <div class="input-wrapper">
                                    <i class="fas fa-lock"></i>
                                    <input type="password" 
                                           class="form-control-premium @error('current_password') is-invalid @enderror" 
                                           id="current_password" 
                                           name="current_password">
                                    <button type="button" class="password-toggle" onclick="togglePassword('current_password')">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                @error('current_password')
                                    <div class="error-message">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label for="new_password" class="form-label-premium">New Password</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-lock"></i>
                                            <input type="password" 
                                                   class="form-control-premium @error('new_password') is-invalid @enderror" 
                                                   id="new_password" 
                                                   name="new_password">
                                            <button type="button" class="password-toggle" onclick="togglePassword('new_password')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>
                                        <small class="form-hint">Minimum 8 characters</small>
                                        @error('new_password')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group-premium">
                                        <label for="new_password_confirmation" class="form-label-premium">Confirm New Password</label>
                                        <div class="input-wrapper">
                                            <i class="fas fa-lock"></i>
                                            <input type="password" 
                                                   class="form-control-premium" 
                                                   id="new_password_confirmation" 
                                                   name="new_password_confirmation">
                                            <button type="button" class="password-toggle" onclick="togglePassword('new_password_confirmation')">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Password Strength Indicator -->
                            <div class="password-strength" id="passwordStrength" style="display: none;">
                                <div class="strength-label">Password Strength:</div>
                                <div class="strength-bar">
                                    <div class="strength-fill" id="strengthFill"></div>
                                </div>
                                <div class="strength-text" id="strengthText">Weak</div>
                            </div>
                        </div>
                    </div>

                    <!-- Email Preferences -->
                    <div class="profile-card-premium" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-header-premium">
                            <h3 class="card-title-premium">
                                <span class="title-icon"><i class="fas fa-bell"></i></span>
                                Email Preferences
                            </h3>
                        </div>
                        
                        <div class="card-body-premium">
                            <div class="preference-list">
                                <div class="preference-item">
                                    <div class="preference-content">
                                        <div class="preference-info">
                                            <h4>Newsletter & Promotions</h4>
                                            <p>Receive updates about new products, sales, and exclusive offers</p>
                                        </div>
                                        <div class="preference-toggle">
                                            <label class="switch-premium">
                                                <input type="checkbox" 
                                                       id="newsletter" 
                                                       name="newsletter" 
                                                       {{ $user->newsletter ?? false ? 'checked' : '' }}>
                                                <span class="slider-premium"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="preference-item">
                                    <div class="preference-content">
                                        <div class="preference-info">
                                            <h4>Order Updates</h4>
                                            <p>Get notified about your order status and shipping updates</p>
                                        </div>
                                        <div class="preference-toggle">
                                            <label class="switch-premium">
                                                <input type="checkbox" 
                                                       id="order_updates" 
                                                       name="order_updates" 
                                                       {{ $user->order_updates ?? true ? 'checked' : '' }}>
                                                <span class="slider-premium"></span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Buttons -->
                    <div class="form-actions-premium" data-aos="fade-up" data-aos-delay="300">
                        <button type="submit" class="btn-save-premium">
                            <i class="fas fa-save"></i>
                            Save Changes
                        </button>
                        <a href="{{ route('account.dashboard') }}" class="btn-cancel-premium">
                            Cancel
                        </a>
                    </div>
                </form>

                <!-- Danger Zone -->
                <div class="danger-zone-premium" data-aos="fade-up" data-aos-delay="400">
                    <div class="danger-header">
                        <h3 class="danger-title">
                            <i class="fas fa-exclamation-triangle"></i>
                            Danger Zone
                        </h3>
                    </div>
                    <div class="danger-content">
                        <p>Once you delete your account, there is no going back. Please be certain.</p>
                        <button type="button" class="btn-delete-account" data-bs-toggle="modal" data-bs-target="#deleteAccountModal">
                            <i class="fas fa-trash"></i>
                            Delete Account
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Delete Account Modal -->
<div class="modal fade premium-modal" id="deleteAccountModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header-danger">
                <h5 class="modal-title-premium">
                    <i class="fas fa-exclamation-triangle"></i>
                    Delete Account
                </h5>
                <button type="button" class="btn-close-premium" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body-premium">
                <div class="warning-message">
                    <i class="fas fa-exclamation-circle"></i>
                    <h4>Are you absolutely sure?</h4>
                    <p>This action <strong>cannot be undone</strong>. This will permanently delete your account and remove all your data including:</p>
                    <ul>
                        <li>Order history</li>
                        <li>Wishlist items</li>
                        <li>Saved addresses</li>
                        <li>Account preferences</li>
                    </ul>
                </div>
            </div>
            <div class="modal-footer-premium">
                <button type="button" class="btn-modal-cancel" data-bs-dismiss="modal">Cancel</button>
                <form action="{{ route('account.delete') }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn-danger-confirm">
                        <i class="fas fa-trash"></i>
                        Yes, Delete My Account
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
/* Hero & Section (reused) */
.account-hero-premium {
    height: 30vh;
    min-height: 250px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
    display: flex;
    align-items: center;
    overflow: hidden;
}

.account-hero-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(255,255,255,.02) 35px,
        rgba(255,255,255,.02) 70px
    );
}

.account-section-premium {
    padding: 4rem 0;
    background: #fafafa;
    min-height: 60vh;
}

/* Alert */
.alert-premium {
    display: flex;
    align-items: start;
    gap: 1rem;
    padding: 1rem 1.5rem;
    margin-bottom: 2rem;
    background: white;
    border-left: 4px solid;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    position: relative;
}

.alert-premium.success {
    border-color: #4CAF50;
    color: #4CAF50;
}

.alert-premium.error {
    border-color: #f44336;
    color: #f44336;
}

.alert-close {
    position: absolute;
    right: 1rem;
    top: 1rem;
    background: none;
    border: none;
    color: inherit;
    cursor: pointer;
    opacity: 0.5;
    transition: opacity 0.3s;
}

.alert-close:hover {
    opacity: 1;
}

/* Profile Cards */
.profile-card-premium {
    background: white;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    overflow: hidden;
    transition: all 0.3s;
}

.profile-card-premium:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
}

.card-header-premium {
    padding: 1.5rem;
    background: linear-gradient(135deg, #fafafa 0%, #fff 100%);
    border-bottom: 2px solid #f0f0f0;
}

.card-title-premium {
    font-size: 1.25rem;
    font-weight: 700;
    color: #000;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.title-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
}

.card-body-premium {
    padding: 2rem;
}

/* Form Elements */
.form-group-premium {
    margin-bottom: 1.5rem;
}

.form-label-premium {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.input-wrapper {
    position: relative;
}

.input-wrapper i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #999;
}

.form-control-premium {
    width: 100%;
    padding: 0.875rem 1rem 0.875rem 2.75rem;
    border: 2px solid #e0e0e0;
    background: white;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control-premium:focus {
    outline: none;
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
}

.form-control-premium[readonly] {
    background: #f8f8f8;
    cursor: not-allowed;
}

.password-toggle {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #999;
    cursor: pointer;
    transition: color 0.3s;
}

.password-toggle:hover {
    color: #333;
}

.form-hint {
    display: block;
    margin-top: 0.5rem;
    color: #999;
    font-size: 0.875rem;
}

.error-message {
    color: #f44336;
    font-size: 0.875rem;
    margin-top: 0.5rem;
}

.section-note {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem;
    background: #f8f8f8;
    border-left: 3px solid #FFB800;
    margin-bottom: 1.5rem;
    color: #666;
}

/* Password Strength */
.password-strength {
    margin-top: 1rem;
    padding: 1rem;
    background: #f8f8f8;
    border-radius: 8px;
}

.strength-label {
    font-size: 0.875rem;
    color: #666;
    margin-bottom: 0.5rem;
}

.strength-bar {
    height: 8px;
    background: #e0e0e0;
    border-radius: 4px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.strength-fill {
    height: 100%;
    transition: all 0.3s;
    border-radius: 4px;
}

.strength-fill.weak {
    width: 25%;
    background: #f44336;
}

.strength-fill.fair {
    width: 50%;
    background: #FFB800;
}

.strength-fill.good {
    width: 75%;
    background: #2196F3;
}

.strength-fill.strong {
    width: 100%;
    background: #4CAF50;
}

.strength-text {
    font-size: 0.875rem;
    font-weight: 600;
}

/* Preferences */
.preference-list {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.preference-item {
    padding: 1.5rem;
    background: #fafafa;
    border-radius: 8px;
    transition: all 0.3s;
}

.preference-item:hover {
    background: #f0f0f0;
}

.preference-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.preference-info h4 {
    font-size: 1rem;
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.preference-info p {
    color: #666;
    font-size: 0.875rem;
    margin: 0;
}

/* Premium Toggle Switch */
.switch-premium {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 30px;
}

.switch-premium input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider-premium {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 30px;
}

.slider-premium:before {
    position: absolute;
    content: "";
    height: 22px;
    width: 22px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: 0.4s;
    border-radius: 50%;
}

input:checked + .slider-premium {
    background: linear-gradient(135deg, #000 0%, #333 100%);
}

input:checked + .slider-premium:before {
    transform: translateX(30px);
}

/* Form Actions */
.form-actions-premium {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
}

.btn-save-premium {
    padding: 1rem 2.5rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-save-premium:hover {
    background: #333;
    transform: translateY(-2px);
}

.btn-cancel-premium {
    padding: 1rem 2.5rem;
    background: white;
    color: #666;
    border: 2px solid #e0e0e0;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
}

.btn-cancel-premium:hover {
    background: #f0f0f0;
    border-color: #999;
    color: #333;
}

/* Danger Zone */
.danger-zone-premium {
    margin-top: 3rem;
    border: 2px solid #f44336;
    background: white;
    overflow: hidden;
}

.danger-header {
    padding: 1rem 1.5rem;
    background: #f44336;
    color: white;
}

.danger-title {
    font-size: 1.125rem;
    font-weight: 700;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.danger-content {
    padding: 2rem;
}

.danger-content p {
    color: #666;
    margin-bottom: 1.5rem;
}

.btn-delete-account {
    padding: 0.75rem 1.5rem;
    background: #f44336;
    color: white;
    border: none;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-delete-account:hover {
    background: #d32f2f;
    transform: translateY(-2px);
}

/* Modal Styles */
.modal-header-danger {
    background: #f44336;
    color: white;
    padding: 1.5rem;
    border: none;
}

.warning-message {
    text-align: center;
    padding: 1rem;
}

.warning-message i {
    font-size: 3rem;
    color: #f44336;
    margin-bottom: 1rem;
}

.warning-message h4 {
    font-size: 1.25rem;
    margin-bottom: 1rem;
}

.warning-message ul {
    text-align: left;
    max-width: 300px;
    margin: 1rem auto 0;
}

.btn-danger-confirm {
    padding: 0.75rem 1.5rem;
    background: #f44336;
    color: white;
    border: none;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-danger-confirm:hover {
    background: #d32f2f;
}

/* Responsive */
@media (max-width: 768px) {
    .preference-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .form-actions-premium {
        flex-direction: column;
    }
    
    .btn-save-premium,
    .btn-cancel-premium {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Password visibility toggle
function togglePassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = field.nextElementSibling.querySelector('i');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Password strength checker
document.getElementById('new_password')?.addEventListener('input', function() {
    const password = this.value;
    const strengthDiv = document.getElementById('passwordStrength');
    const strengthFill = document.getElementById('strengthFill');
    const strengthText = document.getElementById('strengthText');
    
    if (password.length > 0) {
        strengthDiv.style.display = 'block';
        
        let strength = 0;
        if (password.length >= 8) strength++;
        if (password.match(/[a-z]/)) strength++;
        if (password.match(/[A-Z]/)) strength++;
        if (password.match(/[0-9]/)) strength++;
        if (password.match(/[^a-zA-Z0-9]/)) strength++;
        
        strengthFill.className = 'strength-fill';
        
        if (strength <= 2) {
            strengthFill.classList.add('weak');
            strengthText.textContent = 'Weak';
            strengthText.style.color = '#f44336';
        } else if (strength === 3) {
            strengthFill.classList.add('fair');
            strengthText.textContent = 'Fair';
            strengthText.style.color = '#FFB800';
        } else if (strength === 4) {
            strengthFill.classList.add('good');
            strengthText.textContent = 'Good';
            strengthText.style.color = '#2196F3';
        } else {
            strengthFill.classList.add('strong');
            strengthText.textContent = 'Strong';
            strengthText.style.color = '#4CAF50';
        }
    } else {
        strengthDiv.style.display = 'none';
    }
});

// Form validation animation
document.querySelector('.profile-form-premium')?.addEventListener('submit', function(e) {
    const button = this.querySelector('.btn-save-premium');
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
    button.disabled = true;
});

// Smooth scroll to alerts
if (document.querySelector('.alert-premium')) {
    window.scrollTo({
        top: document.querySelector('.alert-premium').offsetTop - 100,
        behavior: 'smooth'
    });
}
</script>
@endpush
@endsection