<div class="sidebar-premium">
    <!-- User Profile Card -->
    <div class="user-profile-card">
        <div class="profile-gradient"></div>
        <div class="profile-content">
            <div class="profile-avatar">
                <i class="fas fa-user"></i>
                <div class="avatar-status"></div>
            </div>
            <h5 class="profile-name">{{ Auth::user()->name }}</h5>
            <p class="profile-email">{{ Auth::user()->email }}</p>
            <div class="profile-stats">
                <div class="stat-item">
                    <span class="stat-count">{{ Auth::user()->orders()->count() }}</span>
                    <span class="stat-text">Orders</span>
                </div>
                <div class="stat-divider"></div>
                <div class="stat-item">
                    <span class="stat-count">{{ Auth::user()->wishlist()->count() }}</span>
                    <span class="stat-text">Wishlist</span>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Navigation Menu -->
    <div class="sidebar-nav-premium">
        <ul class="nav-menu-premium">
            <li class="nav-item-premium">
                <a class="nav-link-premium {{ request()->routeIs('account.dashboard') ? 'active' : '' }}" 
                   href="{{ route('account.dashboard') }}">
                    <span class="nav-icon"><i class="fas fa-tachometer-alt"></i></span>
                    <span class="nav-text">Dashboard</span>
                    <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                </a>
            </li>
            
            <li class="nav-item-premium">
                <a class="nav-link-premium {{ request()->routeIs('account.orders*') ? 'active' : '' }}" 
                   href="{{ route('account.orders') }}">
                    <span class="nav-icon"><i class="fas fa-shopping-bag"></i></span>
                    <span class="nav-text">My Orders</span>
                    <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                </a>
            </li>
            
            <li class="nav-item-premium">
                <a class="nav-link-premium {{ request()->routeIs('account.wishlist') ? 'active' : '' }}" 
                   href="{{ route('account.wishlist') }}">
                    <span class="nav-icon"><i class="fas fa-heart"></i></span>
                    <span class="nav-text">Wishlist</span>
                    <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                </a>
            </li>
            
            <li class="nav-item-premium">
                <a class="nav-link-premium {{ request()->routeIs('account.addresses') ? 'active' : '' }}" 
                   href="{{ route('account.addresses') }}">
                    <span class="nav-icon"><i class="fas fa-map-marker-alt"></i></span>
                    <span class="nav-text">Addresses</span>
                    <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                </a>
            </li>
            
            <li class="nav-item-premium">
                <a class="nav-link-premium {{ request()->routeIs('account.profile') ? 'active' : '' }}" 
                   href="{{ route('account.profile') }}">
                    <span class="nav-icon"><i class="fas fa-user-edit"></i></span>
                    <span class="nav-text">Profile Settings</span>
                    <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                </a>
            </li>
            
            <li class="nav-item-premium nav-divider"></li>
            
            <li class="nav-item-premium">
                <form method="POST" action="{{ route('logout') }}" id="logout-form">
                    @csrf
                    <button type="submit" class="nav-link-premium logout-btn">
                        <span class="nav-icon"><i class="fas fa-sign-out-alt"></i></span>
                        <span class="nav-text">Logout</span>
                        <span class="nav-arrow"><i class="fas fa-chevron-right"></i></span>
                    </button>
                </form>
            </li>
        </ul>
    </div>
    
    <!-- Help Card -->
    <div class="help-card-premium">
        <div class="help-icon">
            <i class="fas fa-headset"></i>
        </div>
        <h6 class="help-title">Need Help?</h6>
        <p class="help-text">Our support team is here to assist you</p>
        <a href="{{ route('contact') }}" class="help-btn">Contact Support</a>
    </div>
</div>

<style>
/* Premium Sidebar Styles */
.sidebar-premium {
    position: sticky;
    top: 100px;
}

/* User Profile Card */
.user-profile-card {
    background: white;
    border-radius: 0;
    overflow: hidden;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
    transition: all 0.3s;
}

.user-profile-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.1);
}

.profile-gradient {
    height: 80px;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    position: relative;
}

.profile-gradient::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    height: 30px;
    background: linear-gradient(to bottom, transparent, white);
}

.profile-content {
    padding: 0 1.5rem 1.5rem;
    text-align: center;
}

.profile-avatar {
    width: 80px;
    height: 80px;
    background: white;
    border: 4px solid white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: -40px auto 1rem;
    position: relative;
}

.profile-avatar i {
    font-size: 2rem;
    color: #000;
}

.avatar-status {
    position: absolute;
    bottom: 5px;
    right: 5px;
    width: 16px;
    height: 16px;
    background: #4CAF50;
    border: 3px solid white;
    border-radius: 50%;
}

.profile-name {
    font-size: 1.125rem;
    font-weight: 700;
    color: #000;
    margin-bottom: 0.25rem;
    font-family: 'Space Grotesk', sans-serif;
}

.profile-email {
    font-size: 0.875rem;
    color: #666;
    margin-bottom: 1rem;
}

.profile-stats {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 1.5rem;
    padding-top: 1rem;
    border-top: 1px solid #f0f0f0;
}

.stat-item {
    text-align: center;
}

.stat-count {
    display: block;
    font-size: 1.25rem;
    font-weight: 700;
    color: #000;
    margin-bottom: 0.25rem;
}

.stat-text {
    font-size: 0.75rem;
    color: #999;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.stat-divider {
    width: 1px;
    height: 30px;
    background: #e0e0e0;
}

/* Navigation Menu */
.sidebar-nav-premium {
    background: white;
    margin-bottom: 1.5rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.nav-menu-premium {
    list-style: none;
    padding: 0;
    margin: 0;
}

.nav-item-premium {
    position: relative;
}

.nav-divider {
    height: 1px;
    background: #f0f0f0;
    margin: 0.5rem 0;
}

.nav-link-premium,
.logout-btn {
    display: flex;
    align-items: center;
    padding: 1rem 1.5rem;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
    position: relative;
    border: none;
    background: none;
    width: 100%;
    text-align: left;
    cursor: pointer;
}

.nav-link-premium::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 3px;
    background: #000;
    transform: scaleY(0);
    transition: transform 0.3s;
}

.nav-link-premium:hover,
.logout-btn:hover {
    background: #fafafa;
    color: #000;
}

.nav-link-premium:hover::before,
.logout-btn:hover::before {
    transform: scaleY(1);
}

.nav-link-premium.active {
    background: linear-gradient(90deg, rgba(0,0,0,0.05) 0%, transparent 100%);
    color: #000;
}

.nav-link-premium.active::before {
    transform: scaleY(1);
}

.nav-icon {
    width: 35px;
    height: 35px;
    background: #f8f8f8;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
    transition: all 0.3s;
}

.nav-link-premium:hover .nav-icon,
.logout-btn:hover .nav-icon {
    background: #000;
    color: white;
}

.nav-link-premium.active .nav-icon {
    background: #000;
    color: white;
}

.nav-text {
    flex: 1;
    font-weight: 500;
    font-size: 0.9375rem;
}

.nav-arrow {
    opacity: 0;
    transform: translateX(-10px);
    transition: all 0.3s;
}

.nav-link-premium:hover .nav-arrow,
.logout-btn:hover .nav-arrow {
    opacity: 1;
    transform: translateX(0);
}

/* Help Card */
.help-card-premium {
    background: linear-gradient(135deg, #000 0%, #333 100%);
    color: white;
    padding: 1.5rem;
    text-align: center;
    position: relative;
    overflow: hidden;
}

.help-card-premium::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    animation: float 6s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translate(0, 0) rotate(0deg); }
    50% { transform: translate(-30px, -30px) rotate(180deg); }
}

.help-icon {
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(10px);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    position: relative;
    z-index: 1;
}

.help-icon i {
    font-size: 1.25rem;
}

.help-title {
    font-size: 1rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    position: relative;
    z-index: 1;
}

.help-text {
    font-size: 0.875rem;
    opacity: 0.9;
    margin-bottom: 1rem;
    position: relative;
    z-index: 1;
}

.help-btn {
    display: inline-block;
    padding: 0.5rem 1.5rem;
    background: white;
    color: #000;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.875rem;
    transition: all 0.3s;
    position: relative;
    z-index: 1;
}

.help-btn:hover {
    background: #f0f0f0;
    transform: translateY(-2px);
}

/* Responsive */
@media (max-width: 991px) {
    .sidebar-premium {
        position: static;
        margin-bottom: 2rem;
    }
    
    .nav-menu-premium {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
    }
    
    .nav-item-premium {
        flex: 1 1 calc(50% - 0.25rem);
        min-width: 150px;
    }
    
    .nav-divider {
        display: none;
    }
}

@media (max-width: 576px) {
    .nav-item-premium {
        flex: 1 1 100%;
    }
}
</style>

<script>
// Add ripple effect to navigation items
document.querySelectorAll('.nav-link-premium, .logout-btn').forEach(item => {
    item.addEventListener('click', function(e) {
        let ripple = document.createElement('span');
        ripple.classList.add('ripple');
        this.appendChild(ripple);
        
        let x = e.clientX - e.target.offsetLeft;
        let y = e.clientY - e.target.offsetTop;
        
        ripple.style.left = `${x}px`;
        ripple.style.top = `${y}px`;
        
        setTimeout(() => {
            ripple.remove();
        }, 600);
    });
});
</script>