@extends('admin.layouts.admin')

@section('title', 'Edit Banner')

@section('content')
<div class="mb-4">
    <h1>Edit Banner</h1>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.banners.index') }}">Banners</a></li>
            <li class="breadcrumb-item active">Edit</li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Banner Details</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.banners.update', $banner) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control @error('title') is-invalid @enderror" 
                               id="title" 
                               name="title" 
                               value="{{ old('title', $banner->title) }}" 
                               required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="subtitle" class="form-label">Subtitle</label>
                        <input type="text" 
                               class="form-control @error('subtitle') is-invalid @enderror" 
                               id="subtitle" 
                               name="subtitle" 
                               value="{{ old('subtitle', $banner->subtitle) }}">
                        @error('subtitle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" 
                                  name="description" 
                                  rows="3">{{ old('description', $banner->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="position" class="form-label">Position <span class="text-danger">*</span></label>
                        <select class="form-select @error('position') is-invalid @enderror" 
                                id="position" 
                                name="position" 
                                required>
                            <option value="">Select Position</option>
                            <option value="hero" {{ old('position', $banner->position) == 'hero' ? 'selected' : '' }}>Hero Banner (1920x800px)</option>
                            <option value="promo_left" {{ old('position', $banner->position) == 'promo_left' ? 'selected' : '' }}>Promotional Left (600x400px)</option>
                            <option value="promo_right" {{ old('position', $banner->position) == 'promo_right' ? 'selected' : '' }}>Promotional Right (600x400px)</option>
                            <option value="home_hero_slider" {{ old('position', $banner->position) == 'home_hero_slider' ? 'selected' : '' }}>Home Hero Slider (1920x600px)</option>
                            <option value="below_categories_slider" {{ old('position', $banner->position) == 'below_categories_slider' ? 'selected' : '' }}>Below Categories Slider (1920x400px)</option>
                            <option value="train_slider" {{ old('position', $banner->position) == 'train_slider' ? 'selected' : '' }}>Train Slider (400x300px)</option>
                        </select>
                        @error('position')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text" id="positionHelp">
                            Select where this banner will be displayed on the homepage.
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Banner Image</label>
                        <input type="file" 
                               class="form-control @error('image') is-invalid @enderror" 
                               id="image" 
                               name="image" 
                               accept="image/jpeg,image/png,image/jpg,image/webp">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">
                            Leave empty to keep current image. Accepted formats: JPEG, PNG, JPG, WEBP. Max size: 2MB
                        </div>
                        <div id="imageSizeRecommendation" class="alert alert-info mt-2">
                            <i class="fas fa-info-circle me-2"></i>
                            <span id="sizeText">
                                @switch($banner->position)
                                    @case('hero')
                                        Recommended size: 1920x800 pixels (Full-width hero banner)
                                        @break
                                    @case('promo_left')
                                        Recommended size: 600x400 pixels (Left promotional banner)
                                        @break
                                    @case('promo_right')
                                        Recommended size: 600x400 pixels (Right promotional banner)
                                        @break
                                    @default
                                        Please select a position first to see size recommendation
                                @endswitch
                            </span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="button_text" class="form-label">Button Text</label>
                                <input type="text" 
                                       class="form-control @error('button_text') is-invalid @enderror" 
                                       id="button_text" 
                                       name="button_text" 
                                       value="{{ old('button_text', $banner->button_text) }}"
                                       placeholder="e.g., SHOP NOW">
                                @error('button_text')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="button_link" class="form-label">Button Link</label>
                                <input type="text" 
                                       class="form-control @error('button_link') is-invalid @enderror" 
                                       id="button_link" 
                                       name="button_link" 
                                       value="{{ old('button_link', $banner->button_link) }}"
                                       placeholder="e.g., /shop">
                                @error('button_link')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', $banner->sort_order) }}"
                                       min="0">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Lower numbers appear first</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="is_active" 
                                           name="is_active" 
                                           value="1"
                                           {{ old('is_active', $banner->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        Active (Display on homepage)
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.banners.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Banner
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Current Image</h5>
            </div>
            <div class="card-body">
                <div id="currentImage" class="mb-3">
                    <img src="{{ \App\Helpers\ImageHelper::getImageUrl($banner->image) }}" 
                         class="img-fluid" 
                         alt="{{ $banner->title }}">
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">New Image Preview</h5>
            </div>
            <div class="card-body">
                <div id="imagePreview" class="text-center">
                    <i class="fas fa-image fa-3x text-muted"></i>
                    <p class="text-muted mt-2">Select a new image to preview</p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Position-based size recommendations
document.getElementById('position').addEventListener('change', function() {
    const sizeText = document.getElementById('sizeText');
    const recommendations = {
        'hero': 'Recommended size: 1920x800 pixels (Full-width hero banner)',
        'promo_left': 'Recommended size: 600x400 pixels (Left promotional banner)',
        'promo_right': 'Recommended size: 600x400 pixels (Right promotional banner)',
        'home_hero_slider': 'Recommended size: 1920x600 pixels (Full-width animated slider)',
        'below_categories_slider': 'Recommended size: 1920x400 pixels (Content section slider)',
        'train_slider': 'Recommended size: 400x300 pixels (Train car images with PNG support)'
    };
    
    if (this.value && recommendations[this.value]) {
        sizeText.textContent = recommendations[this.value];
    } else {
        sizeText.textContent = 'Please select a position first to see size recommendation';
    }
});

// Image preview
document.getElementById('image').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById('imagePreview');
    
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.innerHTML = `<img src="${e.target.result}" class="img-fluid" alt="Preview">`;
        }
        reader.readAsDataURL(file);
    } else {
        preview.innerHTML = `
            <i class="fas fa-image fa-3x text-muted"></i>
            <p class="text-muted mt-2">Select a new image to preview</p>
        `;
    }
});
</script>
@endpush

@endsection