@extends('admin.layouts.admin')

@section('title', 'Edit Blog Post')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0">Edit Blog Post</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.blogs.index') }}">Blogs</a></li>
                <li class="breadcrumb-item active">Edit</li>
            </ol>
        </nav>
    </div>
</div>
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('admin.blogs.update', $blog) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
                <div class="row">
                    <div class="col-md-8">
                        <!-- Main Content Card -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Blog Content</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                           id="title" name="title" value="{{ old('title', $blog->title) }}" required>
                                    @error('title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="excerpt">Excerpt <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('excerpt') is-invalid @enderror" 
                                              id="excerpt" name="excerpt" rows="3" required>{{ old('excerpt', $blog->excerpt) }}</textarea>
                                    @error('excerpt')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Brief summary of the blog post (used in blog listing and SEO)</small>
                                </div>

                                <div class="form-group">
                                    <label for="content">Content <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('content') is-invalid @enderror" 
                                              id="content" name="content" rows="15" required>{{ old('content', $blog->content) }}</textarea>
                                    @error('content')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Full blog post content (HTML supported)</small>
                                </div>
                            </div>
                        </div>

                        <!-- SEO Card -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">SEO Settings</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="meta_title">Meta Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('meta_title') is-invalid @enderror" 
                                           id="meta_title" name="meta_title" value="{{ old('meta_title', $blog->meta_title) }}" 
                                           maxlength="255" required>
                                    @error('meta_title')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">SEO title for search engines (recommended: 50-60 characters)</small>
                                </div>

                                <div class="form-group">
                                    <label for="meta_description">Meta Description <span class="text-danger">*</span></label>
                                    <textarea class="form-control @error('meta_description') is-invalid @enderror" 
                                              id="meta_description" name="meta_description" rows="3" 
                                              maxlength="255" required>{{ old('meta_description', $blog->meta_description) }}</textarea>
                                    @error('meta_description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">SEO description for search engines (recommended: 120-160 characters)</small>
                                </div>

                                <div class="form-group">
                                    <label for="meta_keywords">Meta Keywords</label>
                                    <input type="text" class="form-control @error('meta_keywords') is-invalid @enderror" 
                                           id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $blog->meta_keywords) }}">
                                    @error('meta_keywords')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Comma-separated keywords (optional)</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <!-- Publish Settings Card -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Publish Settings</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="author">Author <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('author') is-invalid @enderror" 
                                           id="author" name="author" value="{{ old('author', $blog->author) }}" required>
                                    @error('author')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="read_time">Read Time (minutes)</label>
                                    <input type="number" class="form-control @error('read_time') is-invalid @enderror" 
                                           id="read_time" name="read_time" value="{{ old('read_time', $blog->read_time) }}" 
                                           min="1" max="60">
                                    @error('read_time')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Leave empty to auto-calculate</small>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" 
                                               id="is_published" name="is_published" value="1" 
                                               {{ old('is_published', $blog->is_published) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_published">Published</label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" 
                                               id="is_featured" name="is_featured" value="1" 
                                               {{ old('is_featured', $blog->is_featured) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_featured">Featured</label>
                                    </div>
                                </div>

                                @if($blog->published_at)
                                <div class="form-group">
                                    <label>Published Date</label>
                                    <p class="form-control-static">{{ $blog->published_at->format('F j, Y \a\t g:i A') }}</p>
                                </div>
                                @endif

                                <div class="form-group">
                                    <label>Views</label>
                                    <p class="form-control-static">{{ number_format($blog->views) }}</p>
                                </div>

                                <div class="form-group">
                                    <label>Slug</label>
                                    <p class="form-control-static">{{ $blog->slug }}</p>
                                    <small class="form-text text-muted">Auto-generated from title</small>
                                </div>
                            </div>
                        </div>

                        <!-- Featured Image Card -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Featured Image</h3>
                            </div>
                            <div class="card-body">
                                @if($blog->featured_image)
                                <div class="current-image mb-3">
                                    <label>Current Image</label>
                                    <div class="mt-2">
                                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($blog->featured_image) }}" 
                                             alt="{{ $blog->title }}" 
                                             class="img-fluid rounded" 
                                             style="max-width: 100%; max-height: 200px;">
                                    </div>
                                </div>
                                @endif

                                <div class="form-group">
                                    <label for="featured_image">{{ $blog->featured_image ? 'Replace Image' : 'Upload Image' }}</label>
                                    <input type="file" class="form-control-file @error('featured_image') is-invalid @enderror" 
                                           id="featured_image" name="featured_image" accept="image/*">
                                    @error('featured_image')
                                        <span class="invalid-feedback d-block">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Max size: 2MB. Supported formats: JPEG, PNG, JPG, GIF</small>
                                </div>

                                <div id="image-preview" class="mt-3" style="display: none;">
                                    <label>New Image Preview</label>
                                    <div class="mt-2">
                                        <img id="preview-img" src="" alt="Preview" class="img-fluid rounded" style="max-width: 100%; max-height: 200px;">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Tags Card -->
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Tags</h3>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="tags">Tags</label>
                                    <input type="text" class="form-control @error('tags') is-invalid @enderror" 
                                           id="tags" name="tags" value="{{ old('tags', $blog->tags ? implode(', ', $blog->tags) : '') }}" 
                                           placeholder="Export, Australia, Trade, Business">
                                    @error('tags')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                    <small class="form-text text-muted">Comma-separated tags for better organization and SEO</small>
                                </div>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="card">
                            <div class="card-body">
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-save"></i> Update Blog Post
                                </button>
                                <a href="{{ route('admin.blogs.index') }}" class="btn btn-secondary ml-2">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                                <a href="{{ route('blogs.show', $blog->slug) }}" class="btn btn-info ml-2" target="_blank">
                                    <i class="fas fa-eye"></i> View Post
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
</form>

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/theme/monokai.min.css">
@endpush

@push('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/xml/xml.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/javascript/javascript.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/css/css.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/htmlmixed/htmlmixed.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize CodeMirror for content textarea
    var contentEditor = CodeMirror.fromTextArea(document.getElementById('content'), {
        mode: 'htmlmixed',
        theme: 'monokai',
        lineNumbers: true,
        lineWrapping: true,
        autoCloseTags: true,
        matchBrackets: true,
        indentUnit: 2
    });

    // Image preview
    $('#featured_image').change(function() {
        var file = this.files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#preview-img').attr('src', e.target.result);
                $('#image-preview').show();
            }
            reader.readAsDataURL(file);
        } else {
            $('#image-preview').hide();
        }
    });

    // Character count for meta fields
    function updateCharCount(inputId, maxLength) {
        var $input = $('#' + inputId);
        var $parent = $input.closest('.form-group');
        var currentLength = $input.val().length;
        var remaining = maxLength - currentLength;
        
        $parent.find('.char-count').remove();
        $parent.append('<small class="form-text text-muted char-count">' + currentLength + '/' + maxLength + ' characters</small>');
        
        if (remaining < 20) {
            $parent.find('.char-count').addClass('text-warning');
        }
        if (remaining < 0) {
            $parent.find('.char-count').removeClass('text-warning').addClass('text-danger');
        }
    }

    $('#meta_title').on('input', function() {
        updateCharCount('meta_title', 60);
    });

    $('#meta_description').on('input', function() {
        updateCharCount('meta_description', 160);
    });

    // Initialize character counts
    updateCharCount('meta_title', 60);
    updateCharCount('meta_description', 160);
});
</script>
@endpush
@endsection