@extends('admin.layouts.admin')

@section('title', 'Create Community Page')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Create Community Page</h1>
    <a href="{{ route('admin.community-pages.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i>Back to Pages
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Page Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.community-pages.store') }}" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="page_key" class="form-label">Page Key <span class="text-danger">*</span></label>
                            <input type="text" id="page_key" name="page_key" class="form-control @error('page_key') is-invalid @enderror" 
                                   value="{{ old('page_key') }}" placeholder="e.g., community-gallery" required>
                            <div class="form-text">Unique identifier for the page (lowercase, use hyphens)</div>
                            @error('page_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                            <input type="text" id="title" name="title" class="form-control @error('title') is-invalid @enderror" 
                                   value="{{ old('title') }}" placeholder="Community Gallery" required>
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Page Content</label>
                        <textarea id="content" name="content" class="form-control @error('content') is-invalid @enderror" 
                                  rows="10" placeholder="Enter page content...">{{ old('content') }}</textarea>
                        <div class="form-text">You can use HTML in the content</div>
                        @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="images" class="form-label">Page Images</label>
                        <input type="file" id="images" name="images[]" class="form-control @error('images.*') is-invalid @enderror" 
                               multiple accept="image/*">
                        <div class="form-text">Upload multiple images (JPEG, PNG, JPG, GIF - max 10MB each)</div>
                        @error('images.*')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" id="is_active" name="is_active" class="form-check-input" value="1" 
                                   {{ old('is_active', true) ? 'checked' : '' }}>
                            <label for="is_active" class="form-check-label">Active</label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('admin.community-pages.index') }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Page
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">SEO Settings</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="meta_title" class="form-label">Meta Title</label>
                    <input type="text" id="meta_title" name="meta_title" class="form-control @error('meta_title') is-invalid @enderror" 
                           value="{{ old('meta_title') }}" placeholder="SEO optimized title">
                    <div class="form-text">Recommended: 50-60 characters</div>
                    @error('meta_title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="meta_description" class="form-label">Meta Description</label>
                    <textarea id="meta_description" name="meta_description" class="form-control @error('meta_description') is-invalid @enderror" 
                              rows="4" placeholder="SEO description">{{ old('meta_description') }}</textarea>
                    <div class="form-text">Recommended: 150-160 characters</div>
                    @error('meta_description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Help</h5>
            </div>
            <div class="card-body">
                <h6>Page Key Guidelines:</h6>
                <ul class="small text-muted mb-3">
                    <li>Use lowercase letters</li>
                    <li>Use hyphens for spaces</li>
                    <li>Keep it descriptive but short</li>
                    <li>Examples: community-gallery, community-spotlight</li>
                </ul>

                <h6>Image Usage:</h6>
                <p class="small text-muted">
                    Images uploaded here will be available through the ImageHelper for optimized loading 
                    and hosting compatibility. You can reference them in your page content or use them 
                    for gallery displays.
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Auto-generate page key from title
document.getElementById('title').addEventListener('input', function() {
    const pageKeyField = document.getElementById('page_key');
    if (!pageKeyField.value) {
        const title = this.value.toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .trim();
        pageKeyField.value = title;
    }
});

// Character counters for SEO fields
const metaTitleField = document.getElementById('meta_title');
const metaDescField = document.getElementById('meta_description');

if (metaTitleField) {
    metaTitleField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/60 characters`;
        helpText.className = length > 60 ? 'form-text text-warning' : 'form-text';
    });
}

if (metaDescField) {
    metaDescField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/160 characters`;
        helpText.className = length > 160 ? 'form-text text-warning' : 'form-text';
    });
}
</script>
@endpush