@extends('admin.layouts.admin')

@section('title', 'Edit Community Page')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Edit Community Page</h1>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.community-pages.show', $communityPage) }}" class="btn btn-outline-info">
            <i class="fas fa-eye me-2"></i>View Page
        </a>
        <a href="{{ route('admin.community-pages.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Pages
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Page Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.community-pages.update', $communityPage) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="page_key" class="form-label">Page Key <span class="text-danger">*</span></label>
                            <input type="text" id="page_key" name="page_key" class="form-control @error('page_key') is-invalid @enderror" 
                                   value="{{ old('page_key', $communityPage->page_key) }}" placeholder="e.g., community-gallery" required>
                            <div class="form-text">Unique identifier for the page (lowercase, use hyphens)</div>
                            @error('page_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                            <input type="text" id="title" name="title" class="form-control @error('title') is-invalid @enderror" 
                                   value="{{ old('title', $communityPage->title) }}" placeholder="Community Gallery" required>
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Page Content</label>
                        <textarea id="content" name="content" class="form-control @error('content') is-invalid @enderror" 
                                  rows="10" placeholder="Enter page content...">{{ old('content', $communityPage->content) }}</textarea>
                        <div class="form-text">You can use HTML in the content</div>
                        @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Current Images -->
                    @if($communityPage->images && count($communityPage->images) > 0)
                    <div class="mb-3">
                        <label class="form-label">Current Images</label>
                        <div class="row g-3">
                            @foreach($communityPage->images as $index => $image)
                            <div class="col-md-4">
                                <div class="card">
                                    <img src="{{ \App\Helpers\ImageHelper::getImageUrl($image) }}" class="card-img-top" style="height: 150px; object-fit: cover;">
                                    <div class="card-body p-2">
                                        <div class="form-check">
                                            <input type="checkbox" name="remove_images[]" value="{{ $image }}" 
                                                   id="remove_{{ $index }}" class="form-check-input">
                                            <label for="remove_{{ $index }}" class="form-check-label small text-danger">
                                                Remove this image
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <div class="mb-3">
                        <label for="images" class="form-label">Add New Images</label>
                        <input type="file" id="images" name="images[]" class="form-control @error('images.*') is-invalid @enderror" 
                               multiple accept="image/*">
                        <div class="form-text">Upload additional images (JPEG, PNG, JPG, GIF - max 10MB each)</div>
                        @error('images.*')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" id="is_active" name="is_active" class="form-check-input" value="1" 
                                   {{ old('is_active', $communityPage->is_active) ? 'checked' : '' }}>
                            <label for="is_active" class="form-check-label">Active</label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('admin.community-pages.index') }}" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Page
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">SEO Settings</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="meta_title" class="form-label">Meta Title</label>
                    <input type="text" id="meta_title" name="meta_title" class="form-control @error('meta_title') is-invalid @enderror" 
                           value="{{ old('meta_title', $communityPage->meta_title) }}" placeholder="SEO optimized title">
                    <div class="form-text">Recommended: 50-60 characters</div>
                    @error('meta_title')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="meta_description" class="form-label">Meta Description</label>
                    <textarea id="meta_description" name="meta_description" class="form-control @error('meta_description') is-invalid @enderror" 
                              rows="4" placeholder="SEO description">{{ old('meta_description', $communityPage->meta_description) }}</textarea>
                    <div class="form-text">Recommended: 150-160 characters</div>
                    @error('meta_description')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Page Info</h5>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between mb-2">
                    <span class="text-muted">Created:</span>
                    <span>{{ $communityPage->created_at->format('M d, Y g:i A') }}</span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span class="text-muted">Last Updated:</span>
                    <span>{{ $communityPage->updated_at->format('M d, Y g:i A') }}</span>
                </div>
                <div class="d-flex justify-content-between">
                    <span class="text-muted">Images:</span>
                    <span class="badge bg-info">{{ count($communityPage->images ?? []) }}</span>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Help</h5>
            </div>
            <div class="card-body">
                <h6>Image Management:</h6>
                <p class="small text-muted">
                    All images are processed through ImageHelper.php for optimized loading. 
                    Check the boxes above to remove existing images. New images will be added to the collection.
                </p>

                <h6>Usage in Frontend:</h6>
                <p class="small text-muted">
                    Use <code>{{ "\\App\\Helpers\\ImageHelper::getImageUrl(\$imagePath)" }}</code> 
                    to display images with proper hosting compatibility.
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Character counters for SEO fields
const metaTitleField = document.getElementById('meta_title');
const metaDescField = document.getElementById('meta_description');

if (metaTitleField) {
    metaTitleField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/60 characters`;
        helpText.className = length > 60 ? 'form-text text-warning' : 'form-text';
    });
}

if (metaDescField) {
    metaDescField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/160 characters`;
        helpText.className = length > 160 ? 'form-text text-warning' : 'form-text';
    });
}
</script>
@endpush