@extends('admin.layouts.admin')

@section('title', 'View Community Post')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>View Community Post</h1>
    <div class="btn-group">
        <a href="{{ route('admin.community.edit', $community) }}" class="btn btn-warning">
            <i class="fas fa-edit me-2"></i>Edit Post
        </a>
        <a href="{{ route('admin.community.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Community
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <div>
                        <h3>{{ $community->name }}</h3>
                        <p class="text-muted mb-2">
                            <i class="fas fa-map-marker-alt me-1"></i>{{ $community->location }}
                        </p>
                        @if($community->instagram_handle)
                            <p class="text-muted mb-0">
                                <i class="fab fa-instagram me-1"></i>@{{ $community->instagram_handle }}
                            </p>
                        @endif
                    </div>
                    <div class="text-end">
                        @if($community->featured)
                            <span class="badge bg-warning mb-2">
                                <i class="fas fa-star me-1"></i>Featured
                            </span>
                        @endif
                        <div>
                            @if($community->status === 'approved')
                                <span class="badge bg-success">
                                    <i class="fas fa-check-circle me-1"></i>Approved
                                </span>
                            @elseif($community->status === 'pending')
                                <span class="badge bg-warning">
                                    <i class="fas fa-clock me-1"></i>Pending
                                </span>
                            @else
                                <span class="badge bg-danger">
                                    <i class="fas fa-times-circle me-1"></i>Rejected
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                @if($community->image_path)
                    <div class="mb-4">
                        <img src="{{ asset('images/' . $community->image_path) }}" 
                             class="img-fluid rounded shadow-sm" alt="{{ $community->name }}">
                    </div>
                @endif

                <div class="mb-4">
                    <h5>Caption</h5>
                    <p class="lead">{{ $community->caption }}</p>
                </div>

                @if($community->products_featured)
                    <div class="mb-4">
                        <h6>Products Featured</h6>
                        <p>{{ $community->products_featured }}</p>
                    </div>
                @endif

                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <i class="fas fa-heart text-danger me-1"></i>
                        <span class="fw-bold">{{ number_format($community->likes) }}</span> likes
                    </div>
                    <div class="text-muted small">
                        Submitted {{ $community->created_at->format('M d, Y g:i A') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Quick Actions</h5>
                
                <div class="d-grid gap-2">
                    @if($community->status === 'pending')
                        <form action="{{ route('admin.community.approve', $community) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success w-100">
                                <i class="fas fa-check me-2"></i>Approve Post
                            </button>
                        </form>
                        <form action="{{ route('admin.community.reject', $community) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-danger w-100">
                                <i class="fas fa-times me-2"></i>Reject Post
                            </button>
                        </form>
                    @endif

                    <button type="button" class="btn btn-outline-warning w-100" onclick="toggleFeatured({{ $community->id }})">
                        @if($community->featured)
                            <i class="fas fa-star-half-alt me-2"></i>Remove from Featured
                        @else
                            <i class="fas fa-star me-2"></i>Mark as Featured
                        @endif
                    </button>

                    <form action="{{ route('admin.community.destroy', $community) }}" method="POST" 
                          onsubmit="return confirm('Are you sure you want to delete this post? This action cannot be undone.')" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash me-2"></i>Delete Post
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Post Details</h5>
                
                <table class="table table-sm">
                    <tbody>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                @if($community->status === 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @elseif($community->status === 'pending')
                                    <span class="badge bg-warning">Pending</span>
                                @else
                                    <span class="badge bg-danger">Rejected</span>
                                @endif
                            </td>
                        </tr>
                        @if($community->approved_at)
                            <tr>
                                <td><strong>Approved:</strong></td>
                                <td>{{ $community->approved_at->format('M d, Y g:i A') }}</td>
                            </tr>
                        @endif
                        <tr>
                            <td><strong>Featured:</strong></td>
                            <td>
                                @if($community->featured)
                                    <span class="text-success"><i class="fas fa-check"></i> Yes</span>
                                @else
                                    <span class="text-muted"><i class="fas fa-times"></i> No</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Likes:</strong></td>
                            <td>{{ number_format($community->likes) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Created:</strong></td>
                            <td>{{ $community->created_at->format('M d, Y g:i A') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Updated:</strong></td>
                            <td>{{ $community->updated_at->format('M d, Y g:i A') }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Consent Information</h5>
                
                <div class="mb-2">
                    <strong>Gallery Usage:</strong>
                    @if($community->consent_gallery)
                        <span class="text-success"><i class="fas fa-check"></i> Granted</span>
                    @else
                        <span class="text-danger"><i class="fas fa-times"></i> Not Granted</span>
                    @endif
                </div>
                
                <div class="mb-2">
                    <strong>Social Media:</strong>
                    @if($community->consent_social)
                        <span class="text-success"><i class="fas fa-check"></i> Granted</span>
                    @else
                        <span class="text-danger"><i class="fas fa-times"></i> Not Granted</span>
                    @endif
                </div>
                
                <div class="mb-0">
                    <strong>Marketing:</strong>
                    @if($community->consent_marketing)
                        <span class="text-success"><i class="fas fa-check"></i> Granted</span>
                    @else
                        <span class="text-danger"><i class="fas fa-times"></i> Not Granted</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleFeatured(postId) {
    fetch(`/admin/community/${postId}/toggle-featured`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('Error updating featured status');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error updating featured status');
    });
}
</script>
@endpush