<!-- resources/views/admin/company/edit.blade.php -->
@extends('admin.layouts.admin')

@section('title', 'Company Information')

@section('content')
<div class="mb-4">
    <h1>Company Information</h1>
</div>

<form action="{{ route('admin.company.update') }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    
    <div class="row">
        <div class="col-lg-8">
            <!-- Basic Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="company_name" class="form-label">Company Name *</label>
                        <input type="text" class="form-control @error('company_name') is-invalid @enderror" 
                               id="company_name" name="company_name" value="{{ old('company_name', $companyInfo->company_name) }}" required>
                        @error('company_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="about_us" class="form-label">About Us *</label>
                        <textarea class="form-control @error('about_us') is-invalid @enderror" 
                                  id="about_us" name="about_us" rows="4" required>{{ old('about_us', $companyInfo->about_us) }}</textarea>
                        @error('about_us')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="mission" class="form-label">Mission *</label>
                        <textarea class="form-control @error('mission') is-invalid @enderror" 
                                  id="mission" name="mission" rows="3" required>{{ old('mission', $companyInfo->mission) }}</textarea>
                        @error('mission')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="vision" class="form-label">Vision *</label>
                        <textarea class="form-control @error('vision') is-invalid @enderror" 
                                  id="vision" name="vision" rows="3" required>{{ old('vision', $companyInfo->vision) }}</textarea>
                        @error('vision')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Contact Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Contact Information</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Phone *</label>
                            <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                   id="phone" name="phone" value="{{ old('phone', $companyInfo->phone) }}" required>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email *</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email', $companyInfo->email) }}" required>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="whatsapp" class="form-label">WhatsApp</label>
                        <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" 
                               id="whatsapp" name="whatsapp" value="{{ old('whatsapp', $companyInfo->whatsapp) }}">
                        @error('whatsapp')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="address" class="form-label">Address *</label>
                        <textarea class="form-control @error('address') is-invalid @enderror" 
                                  id="address" name="address" rows="2" required>{{ old('address', $companyInfo->address) }}</textarea>
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Social Media -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Social Media Links</h5>
                </div>
                <div class="card-body">
                    @php
                        $socialLinks = $companyInfo->social_links ?? [];
                    @endphp
                    <div class="mb-3">
                        <label for="facebook" class="form-label">
                            <i class="fab fa-facebook"></i> Facebook
                        </label>
                        <input type="url" class="form-control" id="facebook" name="social_links[facebook]" 
                               value="{{ old('social_links.facebook', $socialLinks['facebook'] ?? '') }}"
                               placeholder="https://www.facebook.com/yourpage">
                    </div>
                    <div class="mb-3">
                        <label for="instagram" class="form-label">
                            <i class="fab fa-instagram"></i> Instagram
                        </label>
                        <input type="url" class="form-control" id="instagram" name="social_links[instagram]" 
                               value="{{ old('social_links.instagram', $socialLinks['instagram'] ?? '') }}"
                               placeholder="https://www.instagram.com/yourprofile">
                    </div>
                    <div class="mb-3">
                        <label for="twitter" class="form-label">
                            <i class="fab fa-twitter"></i> Twitter
                        </label>
                        <input type="url" class="form-control" id="twitter" name="social_links[twitter]" 
                               value="{{ old('social_links.twitter', $socialLinks['twitter'] ?? '') }}"
                               placeholder="https://twitter.com/yourhandle">
                    </div>
                    <div class="mb-3">
                        <label for="linkedin" class="form-label">
                            <i class="fab fa-linkedin"></i> LinkedIn
                        </label>
                        <input type="url" class="form-control" id="linkedin" name="social_links[linkedin]" 
                               value="{{ old('social_links.linkedin', $socialLinks['linkedin'] ?? '') }}"
                               placeholder="https://www.linkedin.com/company/yourcompany">
                    </div>
                    <div class="mb-3">
                        <label for="tiktok" class="form-label">
                            <i class="fab fa-tiktok"></i> TikTok
                        </label>
                        <input type="url" class="form-control" id="tiktok" name="social_links[tiktok]" 
                               value="{{ old('social_links.tiktok', $socialLinks['tiktok'] ?? '') }}"
                               placeholder="https://www.tiktok.com/@yourprofile">
                    </div>
                    <div class="mb-3">
                        <label for="youtube" class="form-label">
                            <i class="fab fa-youtube"></i> YouTube
                        </label>
                        <input type="url" class="form-control" id="youtube" name="social_links[youtube]" 
                               value="{{ old('social_links.youtube', $socialLinks['youtube'] ?? '') }}"
                               placeholder="https://www.youtube.com/c/yourchannel">
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Statistics -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Statistics</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="years_experience" class="form-label">Years of Experience</label>
                        <input type="number" class="form-control @error('years_experience') is-invalid @enderror" 
                               id="years_experience" name="years_experience" value="{{ old('years_experience', $companyInfo->years_experience) }}">
                        @error('years_experience')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="happy_clients" class="form-label">Happy Clients</label>
                        <input type="number" class="form-control @error('happy_clients') is-invalid @enderror" 
                               id="happy_clients" name="happy_clients" value="{{ old('happy_clients', $companyInfo->happy_clients) }}">
                        @error('happy_clients')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="products_count" class="form-label">Products Count</label>
                        <input type="number" class="form-control @error('products_count') is-invalid @enderror" 
                               id="products_count" name="products_count" value="{{ old('products_count', $companyInfo->products_count) }}">
                        @error('products_count')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Export Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Export Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="export_countries" class="form-label">Export Countries</label>
                        <textarea class="form-control @error('export_countries') is-invalid @enderror" 
                                  id="export_countries" name="export_countries" rows="3">{{ old('export_countries', $companyInfo->export_countries) }}</textarea>
                        @error('export_countries')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">Separate countries with commas</small>
                    </div>
                </div>
            </div>

            <!-- Logo -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Company Logo</h5>
                </div>
                <div class="card-body">
                    @if($companyInfo->logo)
                    <div class="mb-3">
                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($companyInfo->logo) }}" alt="Company Logo" class="img-fluid">
                    </div>
                    @endif
                    <div class="mb-3">
                        <label for="logo" class="form-label">Upload New Logo</label>
                        <input type="file" class="form-control @error('logo') is-invalid @enderror"
                               id="logo" name="logo" accept="image/*">
                        @error('logo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            Recommended: PNG or JPG format. Size: 300x100px to 600x200px (3:1 ratio preferred). Max file size: 2MB.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Favicon -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Website Favicon</h5>
                </div>
                <div class="card-body">
                    @if($companyInfo->favicon)
                    <div class="mb-3">
                        <img src="{{ \App\Helpers\ImageHelper::getImageUrl($companyInfo->favicon) }}" alt="Website Favicon" class="img-fluid" style="max-width: 64px; max-height: 64px;">
                        <p class="text-muted mt-2"><small>Current favicon (displayed at 64x64px)</small></p>
                    </div>
                    @endif
                    <div class="mb-3">
                        <label for="favicon" class="form-label">Upload New Favicon</label>
                        <input type="file" class="form-control @error('favicon') is-invalid @enderror"
                               id="favicon" name="favicon" accept=".ico,.png,.jpg,.jpeg,.gif">
                        @error('favicon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            Recommended: ICO, PNG, or JPG format. Size: 16x16, 32x32, or 64x64 pixels. Max file size: 1MB.
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mb-4">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="fas fa-save me-2"></i>Save Changes
        </button>
    </div>
</form>
@endsection