@extends('admin.layouts.admin')
@section('title', 'Coupons')
@section('content')
<div class="container">
    <h1>Coupons Management</h1>
    <a href="{{ route('admin.coupons.create') }}" class="btn btn-primary">Add Coupon</a>
    <table class="table mt-3">
        <thead>
            <tr>
                <th>Code</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Valid Until</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($coupons as $coupon)
            <tr>
                <td>{{ $coupon->code }}</td>
                <td>{{ $coupon->discount_type }}</td>
                <td>{{ $coupon->discount_amount }}</td>
                <td>{{ $coupon->valid_until->format('Y-m-d') }}</td>
                <td>{{ $coupon->is_active ? 'Active' : 'Inactive' }}</td>
                <td>
                    <a href="{{ route('admin.coupons.edit', $coupon) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('admin.coupons.destroy', $coupon) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $coupons->links() }}
</div>
@endsection