@extends('admin.layouts.admin')

@section('title', 'Create Discount Campaign')

@section('content')
<div class="mb-4">
    <h1>Create Discount Campaign</h1>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.discounts.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">Campaign Name *</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" 
                               id="name" name="name" value="{{ old('name') }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="discount_percentage" class="form-label">Discount Percentage *</label>
                        <div class="input-group">
                            <input type="number" class="form-control @error('discount_percentage') is-invalid @enderror" 
                                   id="discount_percentage" name="discount_percentage" 
                                   value="{{ old('discount_percentage') }}" min="1" max="100" required>
                            <span class="input-group-text">%</span>
                        </div>
                        @error('discount_percentage')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control @error('description') is-invalid @enderror" 
                          id="description" name="description" rows="3">{{ old('description') }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="starts_at" class="form-label">Start Date & Time *</label>
                        <input type="datetime-local" class="form-control @error('starts_at') is-invalid @enderror" 
                               id="starts_at" name="starts_at" value="{{ old('starts_at') }}" required>
                        @error('starts_at')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="ends_at" class="form-label">End Date & Time *</label>
                        <input type="datetime-local" class="form-control @error('ends_at') is-invalid @enderror" 
                               id="ends_at" name="ends_at" value="{{ old('ends_at') }}" required>
                        @error('ends_at')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Apply Discount To *</label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="discount_type" 
                           id="discount_all" value="all" checked>
                    <label class="form-check-label" for="discount_all">
                        All Products
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="discount_type" 
                           id="discount_products" value="products">
                    <label class="form-check-label" for="discount_products">
                        Specific Products
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="discount_type" 
                           id="discount_categories" value="categories">
                    <label class="form-check-label" for="discount_categories">
                        Specific Categories
                    </label>
                </div>
            </div>
            
            <div class="mb-3 d-none" id="products_section">
                <label for="product_ids" class="form-label">Select Products</label>
                <select class="form-select select2" id="product_ids" name="product_ids[]" multiple>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}">{{ $product->name }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="mb-3 d-none" id="categories_section">
                <label for="category_ids" class="form-label">Select Categories</label>
                <select class="form-select select2" id="category_ids" name="category_ids[]" multiple>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                    @endforeach
                </select>
            </div>
            
            <div class="mb-3">
                <label for="banner_image" class="form-label">Banner Image</label>
                <input type="file" class="form-control @error('banner_image') is-invalid @enderror" 
                       id="banner_image" name="banner_image" accept="image/*">
                @error('banner_image')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <small class="text-muted">Upload a banner image for the campaign (optional)</small>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="{{ route('admin.discounts.index') }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">Create Campaign</button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $('.select2').select2();
    
    // Show/hide product/category selection based on discount type
    $('input[name="discount_type"]').change(function() {
        var type = $(this).val();
        
        $('#products_section, #categories_section').addClass('d-none');
        
        if (type === 'products') {
            $('#products_section').removeClass('d-none');
        } else if (type === 'categories') {
            $('#categories_section').removeClass('d-none');
        }
    });
});
</script>
@endpush