@extends('admin.layouts.admin')

@section('title', 'View Legal Page')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">{{ $legalPage->title }}</h1>
    <div class="d-flex gap-2">
        @if($legalPage->is_active)
            <a href="{{ route('legal.show', $legalPage->slug) }}" target="_blank" class="btn btn-success">
                <i class="fas fa-external-link-alt"></i> View on Site
            </a>
        @endif
        <a href="{{ route('admin.legal-pages.edit', $legalPage) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
        <a href="{{ route('admin.legal-pages.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-file-alt"></i> Content Preview
                </h6>
            </div>
            <div class="card-body">
                <div class="legal-content-preview">
                    {!! $legalPage->content !!}
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle"></i> Page Details
                </h6>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-4">Title:</dt>
                    <dd class="col-8">{{ $legalPage->title }}</dd>
                    
                    <dt class="col-4">Slug:</dt>
                    <dd class="col-8"><code>{{ $legalPage->slug }}</code></dd>
                    
                    @if($legalPage->meta_description)
                        <dt class="col-4">Meta Description:</dt>
                        <dd class="col-8">{{ $legalPage->meta_description }}</dd>
                    @endif
                    
                    <dt class="col-4">Status:</dt>
                    <dd class="col-8">
                        @if($legalPage->is_active)
                            <span class="badge bg-success">Active</span>
                        @else
                            <span class="badge bg-secondary">Inactive</span>
                        @endif
                    </dd>
                    
                    <dt class="col-4">Created:</dt>
                    <dd class="col-8">{{ $legalPage->created_at->format('M d, Y g:i A') }}</dd>
                    
                    <dt class="col-4">Last Updated:</dt>
                    <dd class="col-8">{{ $legalPage->updated_at->format('M d, Y g:i A') }}</dd>
                </dl>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-cogs"></i> Quick Actions
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.legal-pages.edit', $legalPage) }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-edit"></i> Edit Page
                    </a>
                    
                    <form action="{{ route('admin.legal-pages.toggle-status', $legalPage) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn btn-{{ $legalPage->is_active ? 'warning' : 'success' }} btn-sm w-100">
                            <i class="fas fa-{{ $legalPage->is_active ? 'eye-slash' : 'eye' }}"></i>
                            {{ $legalPage->is_active ? 'Deactivate' : 'Activate' }}
                        </button>
                    </form>
                    
                    @if($legalPage->is_active)
                        <a href="{{ route('legal.show', $legalPage->slug) }}" target="_blank" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-external-link-alt"></i> View on Frontend
                        </a>
                    @endif
                    
                    <form action="{{ route('admin.legal-pages.destroy', $legalPage) }}" 
                          method="POST" 
                          onsubmit="return confirm('Are you sure you want to delete this legal page? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger btn-sm w-100">
                            <i class="fas fa-trash"></i> Delete Page
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.legal-content-preview {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    line-height: 1.6;
    color: #333;
}

.legal-content-preview h1,
.legal-content-preview h2,
.legal-content-preview h3,
.legal-content-preview h4,
.legal-content-preview h5,
.legal-content-preview h6 {
    margin-top: 2rem;
    margin-bottom: 1rem;
    font-weight: 600;
    color: #000;
}

.legal-content-preview h1 {
    font-size: 2.5rem;
    border-bottom: 2px solid #eee;
    padding-bottom: 0.5rem;
}

.legal-content-preview h2 {
    font-size: 2rem;
}

.legal-content-preview h3 {
    font-size: 1.5rem;
}

.legal-content-preview p {
    margin-bottom: 1rem;
}

.legal-content-preview ul,
.legal-content-preview ol {
    margin-bottom: 1rem;
    padding-left: 2rem;
}

.legal-content-preview li {
    margin-bottom: 0.5rem;
}

.legal-content-preview blockquote {
    border-left: 4px solid #ddd;
    padding-left: 1rem;
    margin: 1.5rem 0;
    font-style: italic;
    color: #666;
}

.legal-content-preview a {
    color: #0066cc;
    text-decoration: underline;
}

.legal-content-preview a:hover {
    color: #004499;
}

.legal-content-preview code {
    background: #f5f5f5;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    font-family: 'Courier New', monospace;
    font-size: 0.9em;
}

.legal-content-preview table {
    width: 100%;
    border-collapse: collapse;
    margin: 1rem 0;
}

.legal-content-preview th,
.legal-content-preview td {
    border: 1px solid #ddd;
    padding: 0.75rem;
    text-align: left;
}

.legal-content-preview th {
    background: #f5f5f5;
    font-weight: 600;
}
</style>
@endpush