@extends('admin.layouts.admin')

@section('title', 'Settings')

@section('content')
<div class="container-fluid">
    <h1 class="mb-4">System Settings</h1>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form action="{{ route('admin.settings.update') }}" method="POST">
        @csrf
        @method('PUT')
        
        <!-- General Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">General Settings</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="site_name" class="form-label">Site Name *</label>
                        <input type="text" class="form-control @error('site_name') is-invalid @enderror" 
                               id="site_name" name="site_name" value="{{ old('site_name', $settings['site_name']) }}" required>
                        @error('site_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="admin_email" class="form-label">Admin Email *</label>
                        <input type="email" class="form-control @error('admin_email') is-invalid @enderror" 
                               id="admin_email" name="admin_email" value="{{ old('admin_email', $settings['admin_email']) }}" required>
                        @error('admin_email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="timezone" class="form-label">Timezone</label>
                        <select class="form-select" id="timezone" name="timezone">
                            <option value="UTC" {{ $settings['timezone'] == 'UTC' ? 'selected' : '' }}>UTC</option>
                            <option value="America/New_York" {{ $settings['timezone'] == 'America/New_York' ? 'selected' : '' }}>America/New York</option>
                            <option value="America/Chicago" {{ $settings['timezone'] == 'America/Chicago' ? 'selected' : '' }}>America/Chicago</option>
                            <option value="America/Los_Angeles" {{ $settings['timezone'] == 'America/Los_Angeles' ? 'selected' : '' }}>America/Los Angeles</option>
                            <option value="Europe/London" {{ $settings['timezone'] == 'Europe/London' ? 'selected' : '' }}>Europe/London</option>
                            <option value="Asia/Karachi" {{ $settings['timezone'] == 'Asia/Karachi' ? 'selected' : '' }}>Asia/Karachi</option>
                            <option value="Asia/Kolkata" {{ $settings['timezone'] == 'Asia/Kolkata' ? 'selected' : '' }}>Asia/Kolkata</option>
                        </select>
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="products_per_page" class="form-label">Products Per Page *</label>
                        <input type="number" class="form-control @error('products_per_page') is-invalid @enderror" 
                               id="products_per_page" name="products_per_page" 
                               value="{{ old('products_per_page', $settings['products_per_page']) }}" 
                               min="1" max="100" required>
                        @error('products_per_page')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        <!-- Shop Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Shop Settings</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label for="currency" class="form-label">Currency Code *</label>
                        <input type="text" class="form-control @error('currency') is-invalid @enderror" 
                               id="currency" name="currency" value="{{ old('currency', $settings['currency']) }}" 
                               maxlength="3" required>
                        @error('currency')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="currency_symbol" class="form-label">Currency Symbol *</label>
                        <input type="text" class="form-control @error('currency_symbol') is-invalid @enderror" 
                               id="currency_symbol" name="currency_symbol" 
                               value="{{ old('currency_symbol', $settings['currency_symbol']) }}" required>
                        @error('currency_symbol')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="tax_rate" class="form-label">Tax Rate (%) *</label>
                        <input type="number" class="form-control @error('tax_rate') is-invalid @enderror" 
                               id="tax_rate" name="tax_rate" value="{{ old('tax_rate', $settings['tax_rate']) }}" 
                               min="0" max="100" step="0.01" required>
                        @error('tax_rate')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="low_stock_threshold" class="form-label">Low Stock Alert *</label>
                        <input type="number" class="form-control @error('low_stock_threshold') is-invalid @enderror" 
                               id="low_stock_threshold" name="low_stock_threshold" 
                               value="{{ old('low_stock_threshold', $settings['low_stock_threshold']) }}" 
                               min="1" required>
                        @error('low_stock_threshold')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="shipping_rate" class="form-label">Shipping Rate ($) *</label>
                        <input type="number" class="form-control @error('shipping_rate') is-invalid @enderror" 
                               id="shipping_rate" name="shipping_rate" 
                               value="{{ old('shipping_rate', $settings['shipping_rate']) }}" 
                               min="0" step="0.01" required>
                        @error('shipping_rate')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="free_shipping_threshold" class="form-label">Free Shipping Threshold ($) *</label>
                        <input type="number" class="form-control @error('free_shipping_threshold') is-invalid @enderror" 
                               id="free_shipping_threshold" name="free_shipping_threshold" 
                               value="{{ old('free_shipping_threshold', $settings['free_shipping_threshold']) }}" 
                               min="0" step="0.01" required>
                        @error('free_shipping_threshold')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <hr>

                <h6 class="mb-3">Feature Toggles</h6>
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="allow_guest_checkout" 
                                   name="allow_guest_checkout" value="1" 
                                   {{ $settings['allow_guest_checkout'] ? 'checked' : '' }}>
                            <label class="form-check-label" for="allow_guest_checkout">
                                Allow Guest Checkout
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_reviews" 
                                   name="enable_reviews" value="1" 
                                   {{ $settings['enable_reviews'] ? 'checked' : '' }}>
                            <label class="form-check-label" for="enable_reviews">
                                Enable Product Reviews
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_wishlist" 
                                   name="enable_wishlist" value="1" 
                                   {{ $settings['enable_wishlist'] ? 'checked' : '' }}>
                            <label class="form-check-label" for="enable_wishlist">
                                Enable Wishlist
                            </label>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="enable_coupons" 
                                   name="enable_coupons" value="1" 
                                   {{ $settings['enable_coupons'] ? 'checked' : '' }}>
                            <label class="form-check-label" for="enable_coupons">
                                Enable Coupons
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Email Settings (Optional) -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Email Settings (SMTP)</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="smtp_host" class="form-label">SMTP Host</label>
                        <input type="text" class="form-control" id="smtp_host" name="smtp_host" 
                               value="{{ old('smtp_host', $settings['smtp_host']) }}"
                               placeholder="e.g., smtp.gmail.com">
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="smtp_port" class="form-label">SMTP Port</label>
                        <input type="text" class="form-control" id="smtp_port" name="smtp_port" 
                               value="{{ old('smtp_port', $settings['smtp_port']) }}"
                               placeholder="e.g., 587">
                    </div>
                    
                    <div class="col-md-3 mb-3">
                        <label for="smtp_encryption" class="form-label">Encryption</label>
                        <select class="form-select" id="smtp_encryption" name="smtp_encryption">
                            <option value="">None</option>
                            <option value="tls" {{ $settings['smtp_encryption'] == 'tls' ? 'selected' : '' }}>TLS</option>
                            <option value="ssl" {{ $settings['smtp_encryption'] == 'ssl' ? 'selected' : '' }}>SSL</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="smtp_username" class="form-label">SMTP Username</label>
                        <input type="text" class="form-control" id="smtp_username" name="smtp_username" 
                               value="{{ old('smtp_username', $settings['smtp_username']) }}">
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label for="smtp_password" class="form-label">SMTP Password</label>
                        <input type="password" class="form-control" id="smtp_password" name="smtp_password" 
                               placeholder="Leave blank to keep current">
                        <small class="form-text text-muted">Password is encrypted and not shown</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Maintenance Mode -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Maintenance Mode</h5>
            </div>
            <div class="card-body">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="maintenance_mode" 
                           name="maintenance_mode" value="1" 
                           {{ $settings['maintenance_mode'] ? 'checked' : '' }}>
                    <label class="form-check-label" for="maintenance_mode">
                        Enable Maintenance Mode
                    </label>
                    <small class="form-text text-muted d-block">
                        When enabled, only administrators can access the site
                    </small>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Settings
            </button>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>

    <!-- Cache Management -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="mb-0">Cache Management</h5>
        </div>
        <div class="card-body">
            <p>Clear various caches to ensure settings take effect immediately.</p>
            <div class="btn-group" role="group">
                <form action="{{ url('/admin/settings/clear-cache') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-broom"></i> Clear All Cache
                    </button>
                </form>
                <form action="{{ url('/admin/settings/optimize') }}" method="POST" class="d-inline">
                    @csrf
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-rocket"></i> Optimize Application
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection