@extends('admin.layouts.admin')

@section('title', 'Edit Shipping Zone')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0">Edit Shipping Zone: {{ $shippingZone->city }}, {{ $shippingZone->state }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.shipping-zones.update', $shippingZone) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="city" class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('city') is-invalid @enderror" 
                                       id="city" 
                                       name="city" 
                                       value="{{ old('city', $shippingZone->city) }}" 
                                       required>
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="state" class="form-label">State <span class="text-danger">*</span></label>
                                <select class="form-select @error('state') is-invalid @enderror" 
                                        id="state" 
                                        name="state" 
                                        required>
                                    <option value="">Select State</option>
                                    @foreach($states as $code => $name)
                                        <option value="{{ $code }}" {{ old('state', $shippingZone->state) == $code ? 'selected' : '' }}>
                                            {{ $name }} ({{ $code }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="postcode_range" class="form-label">Postcode Range</label>
                            <input type="text" 
                                   class="form-control @error('postcode_range') is-invalid @enderror" 
                                   id="postcode_range" 
                                   name="postcode_range" 
                                   value="{{ old('postcode_range', $shippingZone->postcode_range) }}"
                                   placeholder="e.g., 2000-2999">
                            <small class="text-muted">Enter a single postcode or range (e.g., 2000-2999)</small>
                            @error('postcode_range')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <hr class="my-4">
                        <h5 class="mb-3">Shipping Rates</h5>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="standard_rate" class="form-label">Standard Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('standard_rate') is-invalid @enderror" 
                                       id="standard_rate" 
                                       name="standard_rate" 
                                       value="{{ old('standard_rate', $shippingZone->standard_rate) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                <small class="text-muted">Set to 0 for free shipping</small>
                                @error('standard_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label for="express_rate" class="form-label">Express Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('express_rate') is-invalid @enderror" 
                                       id="express_rate" 
                                       name="express_rate" 
                                       value="{{ old('express_rate', $shippingZone->express_rate) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                @error('express_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label for="priority_rate" class="form-label">Priority Rate ($) <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('priority_rate') is-invalid @enderror" 
                                       id="priority_rate" 
                                       name="priority_rate" 
                                       value="{{ old('priority_rate', $shippingZone->priority_rate) }}" 
                                       step="0.01" 
                                       min="0" 
                                       required>
                                @error('priority_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="free_shipping_threshold" class="form-label">Free Shipping Threshold ($)</label>
                                <input type="number" 
                                       class="form-control @error('free_shipping_threshold') is-invalid @enderror" 
                                       id="free_shipping_threshold" 
                                       name="free_shipping_threshold" 
                                       value="{{ old('free_shipping_threshold', $shippingZone->free_shipping_threshold) }}" 
                                       step="0.01" 
                                       min="0">
                                <small class="text-muted">Orders above this amount get free standard shipping</small>
                                @error('free_shipping_threshold')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" 
                                       class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" 
                                       name="sort_order" 
                                       value="{{ old('sort_order', $shippingZone->sort_order) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active', $shippingZone->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active (Enable this shipping zone)
                                </label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.shipping-zones.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Zone
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <!-- Current Settings Display -->
            <div class="card mb-3">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0">Current Settings</h5>
                </div>
                <div class="card-body">
                    <dl class="row mb-0">
                        <dt class="col-sm-6">Standard Rate:</dt>
                        <dd class="col-sm-6">
                            @if($shippingZone->standard_rate == 0)
                                <span class="badge bg-success">FREE</span>
                            @else
                                ${{ number_format($shippingZone->standard_rate, 2) }}
                            @endif
                        </dd>
                        
                        <dt class="col-sm-6">Express Rate:</dt>
                        <dd class="col-sm-6">${{ number_format($shippingZone->express_rate, 2) }}</dd>
                        
                        <dt class="col-sm-6">Priority Rate:</dt>
                        <dd class="col-sm-6">${{ number_format($shippingZone->priority_rate, 2) }}</dd>
                        
                        <dt class="col-sm-6">Free Threshold:</dt>
                        <dd class="col-sm-6">
                            @if($shippingZone->free_shipping_threshold)
                                ${{ number_format($shippingZone->free_shipping_threshold, 2) }}
                            @else
                                <span class="text-muted">None</span>
                            @endif
                        </dd>
                        
                        <dt class="col-sm-6">Status:</dt>
                        <dd class="col-sm-6">
                            @if($shippingZone->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-danger">Inactive</span>
                            @endif
                        </dd>
                    </dl>
                </div>
            </div>

            <!-- Help Card -->
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-info-circle"></i> Quick Tips</h5>
                </div>
                <div class="card-body">
                    <ul class="small mb-0">
                        <li>Set competitive rates for major cities</li>
                        <li>Offer free shipping to encourage larger orders</li>
                        <li>Express should be 50-100% more than standard</li>
                        <li>Priority should be 2-3x standard rate</li>
                        <li>Consider distance from your warehouse</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection