@extends('admin.layouts.admin')

@section('title', 'Edit Style Guide')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Edit Style Guide: {{ $styleGuide->name }}</h3>
                    <div>
                        <a href="{{ route('style-guide.show', $styleGuide->slug) }}" 
                           class="btn btn-info" 
                           target="_blank">
                            <i class="fas fa-eye"></i> Preview
                        </a>
                        <a href="{{ route('admin.style-guides.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to Style Guides
                        </a>
                    </div>
                </div>

                <!-- Nav tabs -->
                <ul class="nav nav-tabs" id="styleGuideTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="basic-tab" data-bs-toggle="tab" data-bs-target="#basic" type="button" role="tab">
                            <i class="fas fa-info-circle"></i> Basic Info
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="content-tab" data-bs-toggle="tab" data-bs-target="#content" type="button" role="tab">
                            <i class="fas fa-file-alt"></i> Content
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="details-tab" data-bs-toggle="tab" data-bs-target="#details" type="button" role="tab">
                            <i class="fas fa-list"></i> Style Details
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="gallery-tab" data-bs-toggle="tab" data-bs-target="#gallery" type="button" role="tab">
                            <i class="fas fa-images"></i> Gallery
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="seo-tab" data-bs-toggle="tab" data-bs-target="#seo" type="button" role="tab">
                            <i class="fas fa-search"></i> SEO
                        </button>
                    </li>
                </ul>

                <form action="{{ route('admin.style-guides.update', $styleGuide) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="tab-content p-3">
                        <!-- Basic Info Tab -->
                        <div class="tab-pane fade show active" id="basic" role="tabpanel">
                            @include('admin.style-guides.partials.basic-info')
                        </div>

                        <!-- Content Tab -->
                        <div class="tab-pane fade" id="content" role="tabpanel">
                            @include('admin.style-guides.partials.content')
                        </div>

                        <!-- Style Details Tab -->
                        <div class="tab-pane fade" id="details" role="tabpanel">
                            @include('admin.style-guides.partials.style-details')
                        </div>

                        <!-- Gallery Tab -->
                        <div class="tab-pane fade" id="gallery" role="tabpanel">
                            @include('admin.style-guides.partials.gallery')
                        </div>

                        <!-- SEO Tab -->
                        <div class="tab-pane fade" id="seo" role="tabpanel">
                            @include('admin.style-guides.partials.seo')
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Update Style Guide
                                </button>
                                <a href="{{ route('admin.style-guides.index') }}" class="btn btn-secondary ms-2">
                                    Cancel
                                </a>
                            </div>
                            <div class="col-md-6 text-end">
                                <small class="text-muted">
                                    Last updated: {{ $styleGuide->updated_at->format('M j, Y \a\t g:i A') }}
                                </small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
<script>
$(document).ready(function() {
    // Initialize CKEditor for content
    ClassicEditor
        .create(document.querySelector('#content'))
        .catch(error => {
            console.error(error);
        });

    // Auto-generate slug from name
    $('#name').on('input', function() {
        const name = $(this).val();
        const slug = name.toLowerCase()
            .replace(/[^\w\s-]/g, '')
            .replace(/[\s_-]+/g, '-')
            .replace(/^-+|-+$/g, '');
        $('#slug').val(slug);
    });

    // Dynamic array field management
    function addArrayItem(containerSelector, template) {
        const container = $(containerSelector);
        const index = container.children().length;
        const newItem = template.replace(/\[INDEX\]/g, `[${index}]`).replace(/INDEX/g, index);
        container.append(newItem);
    }

    function removeArrayItem(button) {
        $(button).closest('.array-item').remove();
    }

    // Styling Tips
    $('#add-styling-tip').click(function() {
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="styling_tips[INDEX]" placeholder="Enter styling tip">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        addArrayItem('#styling-tips-container', template);
    });

    // Key Pieces
    $('#add-key-piece').click(function() {
        const template = `
            <div class="array-item mb-2">
                <div class="input-group">
                    <input type="text" class="form-control" name="key_pieces[INDEX]" placeholder="Enter key piece">
                    <button type="button" class="btn btn-outline-danger remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        addArrayItem('#key-pieces-container', template);
    });

    // Remove array item
    $(document).on('click', '.remove-item', function() {
        removeArrayItem(this);
    });

    // Color picker
    $('input[type="color"]').change(function() {
        $(this).siblings('input[type="text"]').val($(this).val());
    });

    // Image preview
    $('input[type="file"]').change(function() {
        const input = this;
        const preview = $(this).siblings('.image-preview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.html(`<img src="${e.target.result}" class="img-thumbnail mt-2" style="max-width: 200px;">`);
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    });
});
</script>
@endpush

@push('styles')
<style>
.nav-tabs .nav-link {
    border: 1px solid transparent;
    border-top-left-radius: 0.375rem;
    border-top-right-radius: 0.375rem;
}

.nav-tabs .nav-link.active {
    color: #495057;
    background-color: #fff;
    border-color: #dee2e6 #dee2e6 #fff;
}

.array-item {
    background: #f8f9fa;
    padding: 10px;
    border-radius: 4px;
    border-left: 3px solid #007bff;
}

.color-swatch {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 2px solid #ddd;
    cursor: pointer;
}

.image-preview {
    min-height: 50px;
}
</style>
@endpush