@extends('admin.layouts.admin')

@section('title', 'Style Guides')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Style Guides Management</h3>
                    <a href="{{ route('admin.style-guides.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Style Guide
                    </a>
                </div>

                <div class="card-body">
                    @if($styleGuides->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Hero Image</th>
                                        <th>Name</th>
                                        <th>Region</th>
                                        <th>Fashion Score</th>
                                        <th>Status</th>
                                        <th>Sort Order</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($styleGuides as $guide)
                                        <tr>
                                            <td>
                                                @if($guide->hero_image)
                                                    <img src="{{ $guide->hero_image_url }}" 
                                                         alt="{{ $guide->name }}" 
                                                         class="img-thumbnail" 
                                                         style="width: 60px; height: 40px; object-fit: cover;">
                                                @else
                                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                                         style="width: 60px; height: 40px;">
                                                        <i class="fas fa-image text-muted"></i>
                                                    </div>
                                                @endif
                                            </td>
                                            <td>
                                                <strong>{{ $guide->name }}</strong>
                                                <br>
                                                <small class="text-muted">{{ $guide->tagline }}</small>
                                            </td>
                                            <td>{{ $guide->region }}</td>
                                            <td>
                                                <span class="badge badge-info">{{ $guide->fashion_score }}/10</span>
                                            </td>
                                            <td>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input toggle-active" 
                                                           type="checkbox" 
                                                           id="toggle_{{ $guide->id }}"
                                                           data-id="{{ $guide->id }}"
                                                           {{ $guide->is_active ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="toggle_{{ $guide->id }}">
                                                        <span class="badge {{ $guide->is_active ? 'badge-success' : 'badge-secondary' }}">
                                                            {{ $guide->is_active ? 'Active' : 'Inactive' }}
                                                        </span>
                                                    </label>
                                                </div>
                                            </td>
                                            <td>{{ $guide->sort_order }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('admin.style-guides.show', $guide) }}" 
                                                       class="btn btn-sm btn-outline-info" 
                                                       title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('admin.style-guides.edit', $guide) }}" 
                                                       class="btn btn-sm btn-outline-primary" 
                                                       title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('admin.style-guides.duplicate', $guide) }}" 
                                                          method="POST" 
                                                          class="d-inline">
                                                        @csrf
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-secondary" 
                                                                title="Duplicate">
                                                            <i class="fas fa-copy"></i>
                                                        </button>
                                                    </form>
                                                    <form action="{{ route('admin.style-guides.destroy', $guide) }}" 
                                                          method="POST" 
                                                          class="d-inline delete-form">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" 
                                                                class="btn btn-sm btn-outline-danger" 
                                                                title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $styleGuides->links() }}
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="fas fa-map-marked-alt fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No style guides found. Create your first style guide to get started!</p>
                            <a href="{{ route('admin.style-guides.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus"></i> Add New Style Guide
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Toggle active status
    $('.toggle-active').change(function() {
        const guideId = $(this).data('id');
        const isActive = $(this).is(':checked');
        
        $.ajax({
            url: `/admin/style-guides/${guideId}/toggle-active`,
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    const badge = $(`#toggle_${guideId}`).siblings('label').find('.badge');
                    if (response.is_active) {
                        badge.removeClass('badge-secondary').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-secondary').text('Inactive');
                    }
                    
                    // Show success message
                    toastr.success(response.message);
                }
            },
            error: function() {
                // Revert toggle on error
                $(`#toggle_${guideId}`).prop('checked', !isActive);
                toastr.error('An error occurred while updating the status.');
            }
        });
    });

    // Delete confirmation
    $('.delete-form').submit(function(e) {
        e.preventDefault();
        
        const form = this;
        const guideName = $(form).closest('tr').find('strong').first().text();
        
        Swal.fire({
            title: 'Are you sure?',
            text: `You are about to delete the style guide "${guideName}". This action cannot be undone!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
});
</script>
@endpush

@push('styles')
<style>
.form-switch .form-check-input {
    width: 2em;
    height: 1em;
}

.btn-group .btn {
    margin-right: 2px;
}

.img-thumbnail {
    border-radius: 4px;
}
</style>
@endpush