<div class="row">
    <div class="col-12">
        <h5 class="mb-3">Content</h5>
        
        <div class="form-group mb-3">
            <label for="content" class="form-label">Content (HTML)</label>
            <textarea class="form-control @error('content') is-invalid @enderror" 
                      id="content" 
                      name="content" 
                      rows="15">{{ old('content', $styleGuide->content) }}</textarea>
            <small class="form-text text-muted">
                Use the rich text editor to format your content. Include headings, paragraphs, lists, and other HTML elements.
            </small>
            @error('content')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="alert alert-info">
            <h6><i class="fas fa-info-circle"></i> Content Tips:</h6>
            <ul class="mb-0">
                <li>Use <code>&lt;h2&gt;</code> and <code>&lt;h3&gt;</code> tags for section headings</li>
                <li>Structure content with <code>&lt;div class="row"&gt;</code> and <code>&lt;div class="col-md-6"&gt;</code> for layouts</li>
                <li>Use <code>&lt;ul&gt;</code> and <code>&lt;li&gt;</code> for lists</li>
                <li>Bold important items with <code>&lt;strong&gt;</code> tags</li>
                <li>Add responsive images with proper classes</li>
            </ul>
        </div>

        <!-- Content Preview -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0">Content Preview</h6>
            </div>
            <div class="card-body">
                <div id="content-preview" class="border p-3" style="min-height: 200px; background: #f8f9fa;">
                    <em class="text-muted">Preview will appear here as you type...</em>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Live content preview
    function updatePreview() {
        const content = $('#content').val();
        $('#content-preview').html(content || '<em class="text-muted">Preview will appear here as you type...</em>');
    }

    // Update preview on input
    $('#content').on('input', updatePreview);
    
    // Initial preview update
    updatePreview();
});
</script>
@endpush