@extends('admin.layouts.admin')

@section('title', 'Style Guide: ' . $styleGuide->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Style Guide: {{ $styleGuide->name }}</h3>
                    <div>
                        <a href="{{ route('style-guide.show', $styleGuide->slug) }}" 
                           class="btn btn-info" 
                           target="_blank">
                            <i class="fas fa-eye"></i> View Live
                        </a>
                        <a href="{{ route('admin.style-guides.edit', $styleGuide) }}" 
                           class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.style-guides.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Basic Information -->
                        <div class="col-md-8">
                            <!-- Hero Section -->
                            @if($styleGuide->hero_image)
                                <div class="hero-section mb-4">
                                    <img src="{{ $styleGuide->hero_image_url }}" 
                                         alt="{{ $styleGuide->name }}" 
                                         class="img-fluid rounded shadow-sm"
                                         style="width: 100%; max-height: 300px; object-fit: cover;">
                                </div>
                            @endif

                            <!-- Basic Info -->
                            <div class="info-section mb-4">
                                <h5>{{ $styleGuide->name }}</h5>
                                <p class="lead text-muted">{{ $styleGuide->tagline }}</p>
                                <p>{{ $styleGuide->description }}</p>
                                
                                <div class="row">
                                    <div class="col-sm-6 col-lg-3 mb-2">
                                        <strong>Region:</strong> {{ $styleGuide->region }}
                                    </div>
                                    <div class="col-sm-6 col-lg-3 mb-2">
                                        <strong>Population:</strong> {{ $styleGuide->population }}
                                    </div>
                                    <div class="col-sm-6 col-lg-3 mb-2">
                                        <strong>Climate:</strong> {{ $styleGuide->climate }}
                                    </div>
                                    <div class="col-sm-6 col-lg-3 mb-2">
                                        <strong>Vibe:</strong> {{ $styleGuide->vibe }}
                                    </div>
                                </div>
                            </div>

                            <!-- Content -->
                            @if($styleGuide->content)
                                <div class="content-section mb-4">
                                    <h5>Content</h5>
                                    <div class="content-preview border rounded p-3" style="background: #f8f9fa;">
                                        {!! $styleGuide->content !!}
                                    </div>
                                </div>
                            @endif

                            <!-- Styling Tips -->
                            @if($styleGuide->styling_tips)
                                <div class="styling-tips mb-4">
                                    <h5>Styling Tips</h5>
                                    <ul class="list-group list-group-flush">
                                        @foreach($styleGuide->styling_tips as $tip)
                                            <li class="list-group-item">
                                                <i class="fas fa-lightbulb text-warning me-2"></i>
                                                {{ $tip }}
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <!-- Style Characteristics -->
                            @if($styleGuide->style_characteristics)
                                <div class="characteristics mb-4">
                                    <h5>Style Characteristics</h5>
                                    <div class="row">
                                        @foreach($styleGuide->style_characteristics as $characteristic)
                                            <div class="col-md-6 mb-3">
                                                <div class="card h-100">
                                                    <div class="card-body">
                                                        <h6 class="card-title text-primary">{{ $characteristic['title'] }}</h6>
                                                        <p class="card-text">{{ $characteristic['description'] }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <!-- Cultural Influences -->
                            @if($styleGuide->cultural_influences)
                                <div class="influences mb-4">
                                    <h5>Cultural Influences</h5>
                                    <div class="row">
                                        @foreach($styleGuide->cultural_influences as $influence)
                                            <div class="col-md-6 mb-2">
                                                <strong>{{ $influence['aspect'] }}:</strong> 
                                                {{ $influence['description'] }}
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>

                        <!-- Sidebar Information -->
                        <div class="col-md-4">
                            <!-- Status & Stats -->
                            <div class="card mb-3">
                                <div class="card-header">
                                    <h6 class="mb-0">Status & Statistics</h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Status:</span>
                                        <span class="badge {{ $styleGuide->is_active ? 'badge-success' : 'badge-secondary' }}">
                                            {{ $styleGuide->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Fashion Score:</span>
                                        <span class="badge badge-info">{{ $styleGuide->fashion_score }}/10</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Streetwear Popularity:</span>
                                        <span class="badge badge-primary">{{ $styleGuide->streetwear_popularity }}%</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Sort Order:</span>
                                        <span>{{ $styleGuide->sort_order }}</span>
                                    </div>
                                    <hr>
                                    <div class="d-flex justify-content-between mb-1">
                                        <span>Created:</span>
                                        <span>{{ $styleGuide->created_at->format('M j, Y') }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <span>Updated:</span>
                                        <span>{{ $styleGuide->updated_at->format('M j, Y') }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Key Pieces -->
                            @if($styleGuide->key_pieces)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Key Pieces</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            @foreach($styleGuide->key_pieces as $piece)
                                                <div class="col-6 mb-2">
                                                    <span class="badge badge-light w-100 text-start py-2">
                                                        {{ $piece }}
                                                    </span>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Color Palette -->
                            @if($styleGuide->color_palette)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Color Palette</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            @foreach($styleGuide->color_palette as $color)
                                                <div class="col-6 mb-3 text-center">
                                                    <div class="color-swatch mx-auto mb-2 rounded-circle" 
                                                         style="width: 50px; height: 50px; background-color: {{ $color['hex'] }}; border: 2px solid #ddd;"></div>
                                                    <small class="d-block">{{ $color['name'] }}</small>
                                                    <small class="text-muted">{{ $color['hex'] }}</small>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <!-- Shopping Areas -->
                            @if($styleGuide->shopping_areas)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Shopping Areas</h6>
                                    </div>
                                    <div class="card-body">
                                        @foreach($styleGuide->shopping_areas as $area)
                                            <div class="mb-3">
                                                <strong>{{ $area['name'] }}</strong>
                                                <p class="small mb-0 text-muted">{{ $area['description'] }}</p>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <!-- Weather Info -->
                            @if($styleGuide->weather)
                                <div class="card mb-3">
                                    <div class="card-header">
                                        <h6 class="mb-0">Weather & Style</h6>
                                    </div>
                                    <div class="card-body">
                                        @if(isset($styleGuide->weather['avg_temp']))
                                            <div class="d-flex justify-content-between mb-2">
                                                <span>Avg Temperature:</span>
                                                <span>{{ $styleGuide->weather['avg_temp'] }}</span>
                                            </div>
                                        @endif
                                        @if(isset($styleGuide->weather['rainfall']))
                                            <div class="d-flex justify-content-between mb-2">
                                                <span>Rainfall:</span>
                                                <span>{{ $styleGuide->weather['rainfall'] }}</span>
                                            </div>
                                        @endif
                                        @if(isset($styleGuide->weather['best_months']))
                                            <div class="d-flex justify-content-between mb-2">
                                                <span>Best Months:</span>
                                                <span>{{ $styleGuide->weather['best_months'] }}</span>
                                            </div>
                                        @endif
                                        @if(isset($styleGuide->weather['style_note']))
                                            <hr>
                                            <p class="small mb-0">{{ $styleGuide->weather['style_note'] }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            <!-- SEO Info -->
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">SEO Information</h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>Slug:</strong>
                                        <code class="small">{{ $styleGuide->slug }}</code>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Meta Title:</strong>
                                        <p class="small mb-0">{{ $styleGuide->meta_title }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Meta Description:</strong>
                                        <p class="small mb-0">{{ $styleGuide->meta_description }}</p>
                                    </div>
                                    <div>
                                        <strong>Keywords:</strong>
                                        <p class="small mb-0">{{ $styleGuide->keywords }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Style Gallery -->
                    @if($styleGuide->style_gallery_urls)
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5>Style Gallery</h5>
                                <div class="row">
                                    @foreach($styleGuide->style_gallery_urls as $galleryItem)
                                        <div class="col-md-3 col-sm-6 mb-3">
                                            <div class="card">
                                                @if(isset($galleryItem['image_url']))
                                                    <img src="{{ $galleryItem['image_url'] }}" 
                                                         class="card-img-top" 
                                                         alt="{{ $galleryItem['alt_text'] ?? $galleryItem['description'] ?? 'Style image' }}"
                                                         style="height: 200px; object-fit: cover;">
                                                @endif
                                                <div class="card-body p-2">
                                                    @if(isset($galleryItem['description']))
                                                        <p class="card-text small mb-1">{{ $galleryItem['description'] }}</p>
                                                    @endif
                                                    @if(isset($galleryItem['style_type']))
                                                        <span class="badge badge-primary">{{ $galleryItem['style_type'] }}</span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection