<!-- resources/views/admin/testimonials/edit.blade.php -->
@extends('admin.layouts.admin')

@section('title', 'Edit Testimonial')

@section('content')
<div class="mb-4">
    <h1>Edit Testimonial</h1>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.testimonials.update', $testimonial) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="client_name" class="form-label">Client Name *</label>
                        <input type="text" class="form-control @error('client_name') is-invalid @enderror" 
                               id="client_name" name="client_name" value="{{ old('client_name', $testimonial->client_name) }}" required>
                        @error('client_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="client_position" class="form-label">Position</label>
                        <input type="text" class="form-control @error('client_position') is-invalid @enderror" 
                               id="client_position" name="client_position" value="{{ old('client_position', $testimonial->client_position) }}">
                        @error('client_position')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="client_company" class="form-label">Company</label>
                        <input type="text" class="form-control @error('client_company') is-invalid @enderror" 
                               id="client_company" name="client_company" value="{{ old('client_company', $testimonial->client_company) }}">
                        @error('client_company')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="client_country" class="form-label">Country *</label>
                        <input type="text" class="form-control @error('client_country') is-invalid @enderror" 
                               id="client_country" name="client_country" value="{{ old('client_country', $testimonial->client_country) }}" required>
                        @error('client_country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="rating" class="form-label">Rating *</label>
                        <select class="form-select @error('rating') is-invalid @enderror" id="rating" name="rating" required>
                            <option value="5" {{ old('rating', $testimonial->rating) == 5 ? 'selected' : '' }}>5 Stars</option>
                            <option value="4" {{ old('rating', $testimonial->rating) == 4 ? 'selected' : '' }}>4 Stars</option>
                            <option value="3" {{ old('rating', $testimonial->rating) == 3 ? 'selected' : '' }}>3 Stars</option>
                            <option value="2" {{ old('rating', $testimonial->rating) == 2 ? 'selected' : '' }}>2 Stars</option>
                            <option value="1" {{ old('rating', $testimonial->rating) == 1 ? 'selected' : '' }}>1 Star</option>
                        </select>
                        @error('rating')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    @if($testimonial->client_image)
                    <div class="mb-3">
                        <label class="form-label">Current Photo</label>
                        <div>
                            <img src="{{ asset('storage/' . $testimonial->client_image) }}" alt="{{ $testimonial->client_name }}" 
                                 class="rounded-circle" width="100" height="100">
                        </div>
                    </div>
                    @endif

                    <div class="mb-3">
                        <label for="client_image" class="form-label">Client Photo</label>
                        <input type="file" class="form-control @error('client_image') is-invalid @enderror" 
                               id="client_image" name="client_image" accept="image/*">
                        @error('client_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Leave empty to keep current photo</small>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" 
                                   value="1" {{ old('is_active', $testimonial->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Testimonial Content *</label>
                <textarea class="form-control @error('content') is-invalid @enderror" 
                          id="content" name="content" rows="4" required>{{ old('content', $testimonial->content) }}</textarea>
                @error('content')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary">Update Testimonial</button>
                <a href="{{ route('admin.testimonials.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection