@extends('layouts.app')

@section('title', $pageData['meta_title'])

@section('meta')
<meta name="description" content="{{ $pageData['meta_description'] }}">
<meta name="keywords" content="{{ $pageData['keywords'] }}">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="fusion-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), url('{{ asset('images/cultural/punjabi-fusion-streetwear-hero.jpg') }}'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="display-3 text-white fw-bold mb-4">{{ $pageData['hero_title'] }}</h1>
                <p class="h3 text-light mb-4">{{ $pageData['hero_subtitle'] }}</p>
                <p class="lead text-white mb-4">Discover authentic Punjabi fusion streetwear that honors heritage while embracing contemporary style. Shop online in Australia for pieces that tell your cultural story.</p>
                
                <div class="hero-features d-flex flex-wrap gap-3 mb-4">
                    <span class="badge bg-primary fs-6 p-2">Authentic Heritage</span>
                    <span class="badge bg-success fs-6 p-2">Modern Streetwear</span>
                    <span class="badge bg-warning fs-6 p-2">Cultural Pride</span>
                    <span class="badge bg-info fs-6 p-2">Australian Made</span>
                </div>
                
                <div class="hero-actions">
                    <a href="{{ route('shop.index') }}" class="btn btn-primary btn-lg me-3">
                        Shop Fusion Collection <i class="fas fa-shopping-bag ms-2"></i>
                    </a>
                    <a href="#what-is-fusion" class="btn btn-outline-light btn-lg">
                        Learn More <i class="fas fa-arrow-down ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- What is Fusion -->
<section id="what-is-fusion" class="what-is-fusion py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="text-center mb-5">What Makes Punjabi Fusion Streetwear Special?</h2>
                <div class="fusion-elements">
                    @foreach($pageData['what_is_fusion'] as $index => $element)
                        <div class="element-item mb-4 p-4 bg-light rounded-lg d-flex align-items-center">
                            <div class="element-icon bg-primary text-white rounded-circle me-4 d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                @if($index === 0)
                                    <i class="fas fa-palette fa-lg"></i>
                                @elseif($index === 1)
                                    <i class="fas fa-tshirt fa-lg"></i>
                                @elseif($index === 2)
                                    <i class="fas fa-brush fa-lg"></i>
                                @elseif($index === 3)
                                    <i class="fas fa-font fa-lg"></i>
                                @else
                                    <i class="fas fa-star fa-lg"></i>
                                @endif
                            </div>
                            <div class="element-content">
                                <p class="mb-0 fw-medium">{{ $element }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Popular Items -->
<section class="popular-items py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Popular Punjabi Fusion Pieces</h2>
                <p class="text-center text-muted lead">Explore our most loved cultural streetwear items</p>
            </div>
        </div>
        
        <div class="row g-4">
            @foreach($pageData['popular_items'] as $item)
                <div class="col-lg-6 col-md-6">
                    <div class="item-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="item-header mb-3">
                            <h4 class="item-name text-primary mb-2">{{ $item['item'] }}</h4>
                            <div class="price-range">
                                <span class="badge bg-secondary">{{ $item['price_range'] }}</span>
                            </div>
                        </div>
                        
                        <p class="item-description mb-3">{{ $item['description'] }}</p>
                        
                        <div class="cultural-elements mb-3 p-3 bg-light rounded">
                            <h6 class="fw-bold mb-2">Cultural Elements:</h6>
                            <p class="text-muted mb-0">{{ $item['cultural_element'] }}</p>
                        </div>
                        
                        <a href="{{ route('shop.index') }}" class="btn btn-outline-primary">
                            Shop {{ $item['item'] }} <i class="fas fa-arrow-right ms-2"></i>
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Featured Products -->
<section class="featured-products py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Shop Authentic Punjabi Fusion</h2>
                <p class="text-center text-muted">Handpicked pieces that perfectly blend heritage with streetwear</p>
            </div>
        </div>
        
        <div class="row g-4">
            @foreach($featuredProducts as $product)
                <div class="col-lg-4 col-md-6">
                    <div class="fusion-product-card h-100 bg-white rounded-lg shadow-sm overflow-hidden">
                        <div class="product-image-wrapper position-relative">
                            <x-lazy-image 
                                :src="$product->featured_image ?? 'placeholder-product.jpg'" 
                                :alt="$product->name"
                                class="img-fluid w-100"
                                style="height: 300px; object-fit: cover;"
                            />
                            <div class="product-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-center justify-content-center opacity-0">
                                <a href="{{ route('shop.product', $product->slug) }}" class="btn btn-primary">
                                    View Details
                                </a>
                            </div>
                            <div class="cultural-badge position-absolute top-0 start-0 m-3">
                                <span class="badge bg-primary">Cultural Fusion</span>
                            </div>
                        </div>
                        
                        <div class="product-info p-4">
                            <h5 class="product-name mb-2">{{ $product->name }}</h5>
                            <div class="product-price fw-bold text-primary mb-3">
                                ${{ number_format($product->price, 2) }}
                            </div>
                            <p class="product-description text-muted small">
                                {{ Str::limit($product->description ?? 'Authentic Punjabi-inspired streetwear piece', 80) }}
                            </p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <div class="text-center mt-5">
            <a href="{{ route('shop.index') }}" class="btn btn-primary btn-lg">
                View Complete Collection <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Why Choose Fusion -->
<section class="why-choose py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <h2 class="mb-4">Why Choose Punjabi Fusion Streetwear?</h2>
                <div class="reasons-list">
                    @foreach($pageData['why_choose_fusion'] as $reason)
                        <div class="reason-item mb-3 d-flex align-items-start">
                            <i class="fas fa-heart text-primary me-3 mt-1"></i>
                            <p class="mb-0">{{ $reason }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <div class="cultural-showcase">
                    <x-lazy-image 
                        src="cultural/punjabi-heritage-modern.jpg" 
                        alt="Punjabi heritage meets modern streetwear"
                        class="img-fluid rounded shadow-lg"
                    />
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Styling Tips -->
<section class="styling-tips py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="text-center mb-5">How to Style Punjabi Fusion Streetwear</h2>
                <div class="tips-grid">
                    @foreach($pageData['styling_tips'] as $index => $tip)
                        <div class="tip-card mb-4 p-4 bg-white rounded-lg shadow-sm">
                            <div class="tip-header d-flex align-items-center mb-3">
                                <div class="tip-number bg-primary text-white rounded-circle me-3" style="width: 40px; height: 40px; display: flex; align-items: center; justify-content: center;">
                                    <span class="fw-bold">{{ $index + 1 }}</span>
                                </div>
                                <h5 class="mb-0">Styling Tip #{{ $index + 1 }}</h5>
                            </div>
                            <p class="mb-0 text-muted">{{ $tip }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Cultural Respect Message -->
<section class="cultural-respect py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="mb-4">Celebrating Culture with Respect</h2>
                <p class="lead mb-4">At Edition By Punjab, we believe in honoring Punjabi heritage through authentic, respectful representation. Every design is created with cultural consultation and deep appreciation for traditions.</p>
                <div class="respect-features row">
                    <div class="col-md-4 mb-3">
                        <i class="fas fa-handshake fa-2x mb-3"></i>
                        <h5>Community Collaboration</h5>
                        <p>Working with Punjabi artists and cultural experts</p>
                    </div>
                    <div class="col-md-4 mb-3">
                        <i class="fas fa-book fa-2x mb-3"></i>
                        <h5>Cultural Education</h5>
                        <p>Sharing the stories behind our designs</p>
                    </div>
                    <div class="col-md-4 mb-3">
                        <i class="fas fa-donate fa-2x mb-3"></i>
                        <h5>Community Support</h5>
                        <p>Supporting cultural preservation initiatives</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="cta py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto text-center">
                <h2 class="mb-4">Start Your Cultural Fashion Journey</h2>
                <p class="lead mb-5">Join thousands of Australians celebrating their heritage through authentic fusion streetwear</p>
                <div class="cta-actions">
                    <a href="{{ route('shop.index') }}" class="btn btn-primary btn-lg me-3">
                        Shop Now <i class="fas fa-shopping-bag ms-2"></i>
                    </a>
                    <a href="{{ route('community.index') }}" class="btn btn-outline-primary btn-lg">
                        Join Community <i class="fas fa-users ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
    .fusion-hero {
        min-height: 700px;
        display: flex;
        align-items: center;
    }
    
    .element-item {
        transition: transform 0.3s ease;
    }
    
    .element-item:hover {
        transform: translateX(10px);
    }
    
    .item-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .item-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .fusion-product-card {
        transition: transform 0.3s ease;
    }
    
    .fusion-product-card:hover {
        transform: translateY(-10px);
    }
    
    .product-overlay {
        background: rgba(0,0,0,0.8);
        transition: opacity 0.3s ease;
    }
    
    .fusion-product-card:hover .product-overlay {
        opacity: 1 !important;
    }
    
    .tip-card {
        transition: transform 0.2s ease;
    }
    
    .tip-card:hover {
        transform: translateY(-5px);
    }
    
    .cultural-showcase img {
        transition: transform 0.3s ease;
    }
    
    .cultural-showcase:hover img {
        transform: scale(1.05);
    }
    
    .rounded-lg {
        border-radius: 1rem;
    }
    
    .hero-features .badge {
        transition: transform 0.2s ease;
    }
    
    .hero-features .badge:hover {
        transform: scale(1.1);
    }
    
    .respect-features i {
        opacity: 0.9;
    }
    
    .cultural-badge {
        backdrop-filter: blur(10px);
    }
</style>
@endpush

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "{{ $pageData['hero_title'] }}",
    "description": "{{ $pageData['meta_description'] }}",
    "url": "{{ route('punjabi-fusion-streetwear') }}",
    "mainEntity": {
        "@type": "ItemList",
        "name": "Punjabi Fusion Streetwear Collection",
        "description": "Authentic Punjabi fusion streetwear combining traditional heritage with modern style",
        "itemListElement": [
            @foreach($pageData['popular_items'] as $index => $item)
            {
                "@type": "Product",
                "position": {{ $index + 1 }},
                "name": "{{ $item['item'] }}",
                "description": "{{ $item['description'] }}",
                "offers": {
                    "@type": "AggregateOffer",
                    "priceCurrency": "AUD",
                    "lowPrice": "{{ explode('-', str_replace(['$', ' '], '', $item['price_range']))[0] }}",
                    "highPrice": "{{ explode('-', str_replace(['$', ' '], '', $item['price_range']))[1] ?? explode('-', str_replace(['$', ' '], '', $item['price_range']))[0] }}"
                }
            }{{ !$loop->last ? ',' : '' }}
            @endforeach
        ]
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "{{ route('home') }}"
    },
    "about": [
        {
            "@type": "Thing",
            "name": "Punjabi Culture",
            "description": "Traditional Punjabi heritage in modern fashion"
        },
        {
            "@type": "Thing",
            "name": "Cultural Fusion Fashion",
            "description": "Streetwear that celebrates cultural identity"
        }
    ]
}
</script>
@endsection