@extends('layouts.app')

@section('title', $cityData['meta_title'])

@section('meta')
<meta name="description" content="{{ $cityData['meta_description'] }}">
<meta name="keywords" content="{{ $cityData['keywords'] }}">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="city-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('{{ asset('images/cities/sydney-fashion-hero.jpg') }}'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="hero-content text-white">
                    <div class="city-badge mb-3">
                        <span class="badge bg-primary me-2">{{ $cityData['name'] }}</span>
                        <span class="badge bg-light text-dark">Harbour City Style</span>
                    </div>
                    <h1 class="display-3 fw-bold mb-4">{{ $cityData['hero_title'] }}</h1>
                    <p class="h4 mb-4 text-light">{{ $cityData['hero_subtitle'] }}</p>
                    <p class="lead mb-4">{{ $cityData['hero_description'] }}</p>
                    
                    <div class="city-stats row g-3 mb-4">
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1">{{ $cityData['population'] }}</div>
                                <small>Population</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1">{{ count($cityData['fashion_districts']) }}</div>
                                <small>Fashion Districts</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1">{{ $cityData['beach_influence'] }}</div>
                                <small>Beach Influence</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1">{{ $cityData['cultural_diversity'] }}</div>
                                <small>Cultural Diversity</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="hero-actions">
                        <a href="{{ route('shop.index') }}" class="btn btn-primary btn-lg me-3">
                            Shop Sydney Collection <i class="fas fa-shopping-bag ms-2"></i>
                        </a>
                        <a href="#fashion-districts" class="btn btn-outline-light btn-lg">
                            Explore Districts <i class="fas fa-map-marker-alt ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- City Introduction -->
<section class="city-intro py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="mb-4">Sydney: Where Beach Meets Sophistication</h2>
                <p class="lead">{{ $cityData['city_intro'] }}</p>
            </div>
        </div>
    </div>
</section>

<!-- Fashion Districts -->
<section id="fashion-districts" class="fashion-districts py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Sydney's Fashion Hotspots</h2>
                <p class="text-center text-muted">From beach to city, discover Sydney's diverse fashion landscape</p>
            </div>
        </div>
        
        <div class="row g-4">
            @foreach($cityData['fashion_districts'] as $district)
                <div class="col-lg-4 col-md-6">
                    <div class="district-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="district-header mb-3">
                            <h5 class="district-name mb-2">{{ $district['name'] }}</h5>
                            <span class="badge bg-info">{{ $district['vibe'] }}</span>
                        </div>
                        <p class="district-description mb-3">{{ $district['description'] }}</p>
                        <div class="district-best-for">
                            <strong>Best for:</strong> {{ $district['best_for'] }}
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Style Characteristics -->
<section class="style-characteristics py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="text-center mb-5">Sydney's Fashion DNA</h2>
                <div class="characteristics-grid">
                    @foreach($cityData['style_characteristics'] as $characteristic)
                        <div class="characteristic-item mb-4 p-4 border-start border-info border-4 bg-light">
                            <h5 class="text-info mb-2">{{ $characteristic['title'] }}</h5>
                            <p class="mb-0">{{ $characteristic['description'] }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Local Trends -->
<section class="local-trends py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">What's Trending in Sydney</h2>
                <p class="text-center text-muted">The latest fashion movements shaping Sydney's streetwear scene</p>
            </div>
        </div>
        
        <div class="row g-4">
            @foreach($cityData['local_trends'] as $trend)
                <div class="col-md-6">
                    <div class="trend-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="trend-header d-flex justify-content-between align-items-center mb-3">
                            <h5 class="trend-name mb-0">{{ $trend['trend'] }}</h5>
                            <div class="popularity-score">
                                <span class="badge bg-success">{{ $trend['popularity'] }}% Popular</span>
                            </div>
                        </div>
                        <p class="trend-description mb-0">{{ $trend['description'] }}</p>
                        <div class="trend-bar mt-3">
                            <div class="progress" style="height: 6px;">
                                <div class="progress-bar bg-info" role="progressbar" style="width: {{ $trend['popularity'] }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Beach to Street Lifestyle -->
<section class="beach-street-lifestyle py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="lifestyle-images">
                    <div class="row g-3">
                        <div class="col-6">
                            <x-lazy-image 
                                src="cities/sydney-beach-style.jpg" 
                                alt="Sydney Beach Fashion"
                                class="img-fluid rounded shadow"
                            />
                        </div>
                        <div class="col-6">
                            <x-lazy-image 
                                src="cities/sydney-street-style.jpg" 
                                alt="Sydney Street Fashion"
                                class="img-fluid rounded shadow"
                            />
                        </div>
                        <div class="col-12">
                            <x-lazy-image 
                                src="cities/sydney-cultural-fashion.jpg" 
                                alt="Sydney Cultural Streetwear"
                                class="img-fluid rounded shadow"
                            />
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <h2 class="mb-4">Why Edition By Punjab Loves Sydney</h2>
                <p class="lead mb-4">Our cultural fusion streetwear perfectly complements Sydney's relaxed yet sophisticated fashion culture.</p>
                
                <ul class="list-unstyled">
                    @foreach($cityData['why_edition_fits'] as $reason)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-info me-3 mt-1"></i>
                            <span>{{ $reason }}</span>
                        </li>
                    @endforeach
                </ul>
                
                <a href="{{ route('shop.index') }}" class="btn btn-info btn-lg text-white">
                    Shop Sydney Collection <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Featured Products for Sydney -->
<section class="featured-products py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Perfect for Sydney Lifestyle</h2>
                <p class="text-center text-muted">Versatile pieces that transition from beach to street</p>
            </div>
        </div>
        
        <div class="row g-4">
            @foreach($relatedProducts->take(4) as $product)
                <div class="col-lg-3 col-md-6">
                    <div class="product-card h-100 bg-white rounded shadow-sm overflow-hidden">
                        <div class="product-image-wrapper position-relative">
                            <x-lazy-image 
                                :src="$product->featured_image ?? 'placeholder-product.jpg'" 
                                :alt="$product->name"
                                class="img-fluid w-100"
                                style="height: 250px; object-fit: cover;"
                            />
                            <div class="product-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-center justify-content-center opacity-0">
                                <a href="{{ route('shop.product', $product->slug) }}" class="btn btn-info text-white">
                                    Shop Now
                                </a>
                            </div>
                            <div class="sydney-badge position-absolute top-0 end-0 m-3">
                                <span class="badge bg-info">Sydney Perfect</span>
                            </div>
                        </div>
                        <div class="product-info p-3">
                            <h6 class="product-name mb-2">{{ $product->name }}</h6>
                            <div class="product-price fw-bold text-info">
                                ${{ number_format($product->price, 2) }}
                            </div>
                            <small class="text-muted">Beach to street ready</small>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <div class="text-center mt-5">
            <a href="{{ route('shop.index') }}" class="btn btn-outline-info btn-lg">
                View All Sydney Favourites <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Local SEO Keywords -->
<section class="local-seo py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h3 class="mb-4">Finding Fashion in Sydney</h3>
                <p class="text-muted mb-4">What Sydney fashion lovers are searching for</p>
                <div class="seo-tags">
                    @foreach($cityData['local_seo_terms'] as $term)
                        <span class="badge bg-light text-dark me-2 mb-2 p-2">{{ $term }}</span>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="cta py-5 bg-info text-white">
    <div class="container text-center">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="mb-4">Ready to Rock Sydney Style?</h2>
                <p class="lead mb-4">Join Sydney's fashion-forward community with Edition By Punjab's cultural streetwear</p>
                <a href="{{ route('shop.index') }}" class="btn btn-light btn-lg me-3">
                    Shop Now <i class="fas fa-shopping-bag ms-2"></i>
                </a>
                <a href="{{ route('community.index') }}" class="btn btn-outline-light btn-lg">
                    Join Community <i class="fas fa-users ms-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
    .city-hero {
        min-height: 700px;
        display: flex;
        align-items: center;
    }
    
    .district-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .district-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .characteristic-item {
        transition: transform 0.2s ease;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .characteristic-item:hover {
        transform: translateX(8px);
    }
    
    .trend-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .trend-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    }
    
    .product-card {
        transition: transform 0.3s ease;
    }
    
    .product-card:hover {
        transform: translateY(-10px);
    }
    
    .product-overlay {
        background: rgba(0,0,0,0.7);
        transition: opacity 0.3s ease;
    }
    
    .product-card:hover .product-overlay {
        opacity: 1 !important;
    }
    
    .rounded-lg {
        border-radius: 1rem;
    }
    
    .seo-tags .badge {
        font-size: 0.9rem;
        transition: transform 0.2s ease;
    }
    
    .seo-tags .badge:hover {
        transform: scale(1.05);
    }
    
    .stat-card {
        backdrop-filter: blur(15px);
        border: 1px solid rgba(255,255,255,0.2);
    }
    
    .lifestyle-images .rounded {
        transition: transform 0.3s ease;
    }
    
    .lifestyle-images .rounded:hover {
        transform: scale(1.05);
    }
    
    .progress-bar {
        transition: width 0.8s ease;
    }
    
    .sydney-badge {
        backdrop-filter: blur(10px);
    }
</style>
@endpush

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "{{ $cityData['hero_title'] }}",
    "description": "{{ $cityData['meta_description'] }}",
    "url": "{{ route('city.sydney') }}",
    "mainEntity": {
        "@type": "Place",
        "name": "Sydney",
        "description": "{{ $cityData['city_intro'] }}",
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": "-33.8688",
            "longitude": "151.2093"
        }
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "{{ route('home') }}"
    },
    "about": [
        {
            "@type": "Thing",
            "name": "Sydney Fashion",
            "description": "Beach to street fashion culture in Sydney Australia"
        },
        {
            "@type": "Thing", 
            "name": "Cultural Streetwear",
            "description": "Punjabi fusion streetwear for Sydney's diverse community"
        }
    ]
}
</script>
@endsection