@props(['src', 'alt', 'class' => '', 'loading' => 'lazy', 'style' => ''])

@php
    // Simple and reliable image handling - skip ImageOptimizer to avoid dependency issues
    $finalSrc = $src;
    $webpSrc = null;
    $srcset = null;

    // Handle different image source types
    if (str_starts_with($finalSrc, 'http') || str_starts_with($finalSrc, '//')) {
        // External URL
        $imageSrc = $finalSrc;
        $fallbackSrc = $finalSrc;
    } elseif (class_exists('\App\Helpers\ImageHelper')) {
        // Use existing ImageHelper if available
        $imageSrc = \App\Helpers\ImageHelper::getImageUrl($finalSrc);
        $fallbackSrc = \App\Helpers\ImageHelper::getImageUrl($src);
    } else {
        // Default to asset helper
        $imageSrc = asset('images/' . $finalSrc);
        $fallbackSrc = asset('images/' . $src);
    }
@endphp

<div class="lazy-image-container {{ $class }}">
    <img 
        src="{{ $imageSrc }}" 
        alt="{{ $alt }}" 
        loading="{{ $loading }}"
        decoding="async"
        class="img-fluid {{ $class }}"
        @if($style)
        style="transition: opacity 0.3s ease-in-out; {{ $style }}"
        @else
        style="transition: opacity 0.3s ease-in-out;"
        @endif
        onload="this.style.opacity=1;"
        onerror="this.src='{{ $fallbackSrc }}'"
        {{ $attributes }}
    >
</div>

@once
@push('styles')
<style>
    .lazy-image-container img {
        opacity: 0;
        transition: opacity 0.3s ease-in-out;
    }
    
    .lazy-image-container img[loading="lazy"] {
        opacity: 1;
    }
    
    .lazy-image-container img.loaded {
        opacity: 1;
    }
</style>
@endpush

@push('scripts')
<script>
    // Enhanced lazy loading with Intersection Observer
    document.addEventListener('DOMContentLoaded', function() {
        if ('IntersectionObserver' in window) {
            const imageObserver = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const img = entry.target;
                        img.classList.add('loaded');
                        observer.unobserve(img);
                    }
                });
            }, {
                rootMargin: '50px 0px',
                threshold: 0.01
            });

            document.querySelectorAll('.lazy-image-container img[loading="lazy"]').forEach(img => {
                imageObserver.observe(img);
            });
        }
    });
</script>
@endpush
@endonce