<!-- Mobile-First SEO Optimizations -->
<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
<meta name="mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<meta name="theme-color" content="#007bff">

<!-- Mobile Performance Optimizations -->
@once
@push('styles')
<style>
    /* Mobile-First Responsive Optimizations */
    
    /* Base mobile styles */
    * {
        box-sizing: border-box;
    }
    
    /* Optimize touch targets for mobile */
    .btn, .nav-link, .dropdown-toggle {
        min-height: 44px;
        min-width: 44px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Mobile navigation optimizations */
    @media (max-width: 767.98px) {
        .navbar-nav {
            text-align: center;
        }
        
        .navbar-nav .nav-link {
            padding: 1rem;
            font-size: 1.1rem;
        }
        
        /* Mobile-friendly product grid */
        .product-grid .col-6 {
            padding-left: 5px;
            padding-right: 5px;
        }
        
        .product-card .card-body {
            padding: 0.75rem;
        }
        
        .product-card .card-title {
            font-size: 0.9rem;
            line-height: 1.2;
        }
        
        /* Mobile blog optimizations */
        .blog-content {
            font-size: 1rem;
            line-height: 1.6;
        }
        
        .blog-content img {
            max-width: 100%;
            height: auto;
        }
        
        /* Mobile form optimizations */
        .form-control {
            font-size: 16px; /* Prevents zoom on iOS */
        }
        
        /* Mobile-friendly tables */
        .table-responsive-mobile {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
    }
    
    /* Tablet optimizations */
    @media (min-width: 768px) and (max-width: 991.98px) {
        .product-grid .col-md-4 {
            flex: 0 0 33.333333%;
            max-width: 33.333333%;
        }
    }
    
    /* Desktop optimizations */
    @media (min-width: 992px) {
        /* Optimize for larger screens */
        .container-xl {
            max-width: 1200px;
        }
        
        /* Enhanced hover effects for desktop */
        .product-card:hover {
            transform: translateY(-5px);
            transition: transform 0.3s ease;
        }
    }
    
    /* Performance optimizations */
    .lazy-load {
        transition: opacity 0.3s;
        opacity: 0;
    }
    
    .lazy-load.loaded {
        opacity: 1;
    }
    
    /* Reduce motion for users who prefer it */
    @media (prefers-reduced-motion: reduce) {
        *, *::before, *::after {
            animation-duration: 0.01ms !important;
            animation-iteration-count: 1 !important;
            transition-duration: 0.01ms !important;
        }
    }
    
    /* High contrast mode support */
    @media (prefers-contrast: high) {
        .btn {
            border: 2px solid;
        }
        
        .card {
            border: 2px solid;
        }
    }
    
    /* Dark mode support */
    @media (prefers-color-scheme: dark) {
        :root {
            --bs-body-bg: #121212;
            --bs-body-color: #e0e0e0;
        }
    }
</style>
@endpush

@push('scripts')
<script>
    // Mobile-specific optimizations
    document.addEventListener('DOMContentLoaded', function() {
        // Detect mobile device
        const isMobile = window.innerWidth <= 768 || /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
        
        if (isMobile) {
            // Add mobile class to body
            document.body.classList.add('is-mobile');
            
            // Optimize touch scrolling
            document.body.style.webkitOverflowScrolling = 'touch';
            
            // Prevent zoom on input focus (iOS)
            const inputs = document.querySelectorAll('input, textarea, select');
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    if (this.style.fontSize !== '16px') {
                        this.style.fontSize = '16px';
                    }
                });
            });
            
            // Mobile-specific lazy loading
            if ('IntersectionObserver' in window) {
                const imageObserver = new IntersectionObserver((entries, observer) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            const img = entry.target;
                            const src = img.dataset.src || img.src;
                            
                            // Load image
                            const newImg = new Image();
                            newImg.onload = function() {
                                img.src = src;
                                img.classList.add('loaded');
                                observer.unobserve(img);
                            };
                            newImg.src = src;
                        }
                    });
                }, {
                    rootMargin: '50px 0px',
                    threshold: 0.01
                });
                
                document.querySelectorAll('img[loading="lazy"]').forEach(img => {
                    imageObserver.observe(img);
                });
            }
        }
        
        // Viewport height fix for mobile browsers
        function setViewportHeight() {
            const vh = window.innerHeight * 0.01;
            document.documentElement.style.setProperty('--vh', `${vh}px`);
        }
        
        setViewportHeight();
        window.addEventListener('resize', setViewportHeight);
        window.addEventListener('orientationchange', setViewportHeight);
        
        // Optimize for Core Web Vitals
        
        // Cumulative Layout Shift (CLS) prevention
        const images = document.querySelectorAll('img:not([width]):not([height])');
        images.forEach(img => {
            // Set aspect ratio to prevent layout shift
            if (img.naturalWidth && img.naturalHeight) {
                const aspectRatio = (img.naturalHeight / img.naturalWidth) * 100;
                img.style.aspectRatio = `${img.naturalWidth} / ${img.naturalHeight}`;
            }
        });
        
        // First Input Delay (FID) optimization
        const criticalButtons = document.querySelectorAll('.btn-primary, .add-to-cart, .checkout-btn');
        criticalButtons.forEach(btn => {
            // Preload critical interaction handlers
            btn.addEventListener('mouseenter', function() {
                // Preload any necessary resources
            }, { once: true });
        });
        
        // Largest Contentful Paint (LCP) optimization
        const hero = document.querySelector('.hero, .banner, .featured-section');
        if (hero) {
            // Ensure hero content is prioritized
            hero.style.contentVisibility = 'visible';
        }
    });
    
    // Service Worker registration for PWA capabilities
    if ('serviceWorker' in navigator && window.location.protocol === 'https:') {
        window.addEventListener('load', function() {
            navigator.serviceWorker.register('/sw.js')
                .then(function(registration) {
                    console.log('SW registered: ', registration);
                })
                .catch(function(registrationError) {
                    console.log('SW registration failed: ', registrationError);
                });
        });
    }
</script>
@endpush
@endonce