@props(['type' => 'products', 'current' => null, 'limit' => 4, 'title' => null])

@php
    $relatedItems = collect();
    $sectionTitle = $title;
    
    switch($type) {
        case 'products':
            if ($current && $current instanceof \App\Models\Product) {
                $relatedItems = \App\Services\InternalLinkingService::getRelatedProducts($current, $limit);
                $sectionTitle = $sectionTitle ?: 'Related Products';
            } else {
                $relatedItems = \App\Services\InternalLinkingService::getContextualProducts('homepage', $limit);
                $sectionTitle = $sectionTitle ?: 'Featured Products';
            }
            break;
            
        case 'blogs':
            if ($current && $current instanceof \App\Models\Blog) {
                $relatedItems = \App\Services\InternalLinkingService::getRelatedBlogs($current, $limit);
                $sectionTitle = $sectionTitle ?: 'Related Articles';
            } else {
                $relatedItems = \App\Models\Blog::where('is_published', true)->where('is_featured', true)->limit($limit)->get();
                $sectionTitle = $sectionTitle ?: 'Featured Articles';
            }
            break;
    }
@endphp

@if($relatedItems->count() > 0)
<section class="related-content py-5" {{ $attributes }}>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h2 class="section-title mb-4">{{ $sectionTitle }}</h2>
            </div>
        </div>
        
        <div class="row">
            @foreach($relatedItems as $item)
                <div class="col-md-6 col-lg-{{ $type === 'products' ? '3' : '4' }} mb-4">
                    @if($type === 'products')
                        <!-- Product Card -->
                        <div class="card product-card h-100 border-0 shadow-sm">
                            @if($item->featured_image)
                                <x-lazy-image 
                                    :src="$item->featured_image" 
                                    :alt="$item->name"
                                    class="card-img-top product-image"
                                    style="height: 200px; object-fit: cover;"
                                />
                            @endif
                            
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">
                                    <a href="{{ route('shop.product', $item->slug) }}" class="text-decoration-none text-dark internal-link">
                                        {{ $item->name }}
                                    </a>
                                </h5>
                                
                                @if($item->short_description)
                                    <p class="card-text text-muted small">{{ Str::limit($item->short_description, 80) }}</p>
                                @endif
                                
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="price fw-bold text-primary">
                                            ${{ number_format($item->price, 2) }}
                                        </span>
                                        <a href="{{ route('shop.product', $item->slug) }}" class="btn btn-sm btn-outline-primary internal-link">
                                            View Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    @elseif($type === 'blogs')
                        <!-- Blog Card -->
                        <div class="card blog-card h-100 border-0 shadow-sm">
                            @if($item->featured_image)
                                <x-lazy-image 
                                    :src="$item->featured_image" 
                                    :alt="$item->title"
                                    class="card-img-top blog-image"
                                    style="height: 200px; object-fit: cover;"
                                />
                            @endif
                            
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">
                                    <a href="{{ route('blogs.show', $item->slug) }}" class="text-decoration-none text-dark internal-link">
                                        {{ $item->title }}
                                    </a>
                                </h5>
                                
                                <p class="card-text text-muted">{{ Str::limit($item->excerpt, 100) }}</p>
                                
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            {{ $item->read_time ?? 5 }} min read
                                        </small>
                                        <a href="{{ route('blogs.show', $item->slug) }}" class="btn btn-sm btn-outline-primary internal-link">
                                            Read More
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
        
        <!-- View All Link -->
        <div class="row mt-4">
            <div class="col-12 text-center">
                @if($type === 'products')
                    <a href="{{ route('shop.index') }}" class="btn btn-primary internal-link">
                        View All Products <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                @elseif($type === 'blogs')
                    <a href="{{ route('blogs.index') }}" class="btn btn-primary internal-link">
                        View All Articles <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                @endif
            </div>
        </div>
    </div>
</section>

@once
@push('styles')
<style>
    .related-content {
        background-color: #f8f9fa;
    }
    
    .section-title {
        color: #2c3e50;
        font-weight: 600;
        position: relative;
        padding-bottom: 10px;
    }
    
    .section-title:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 50px;
        height: 3px;
        background: #007bff;
    }
    
    .product-card, .blog-card {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }
    
    .product-card:hover, .blog-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
    }
    
    .internal-link {
        transition: color 0.2s ease;
    }
    
    .internal-link:hover {
        color: #007bff !important;
    }
    
    .product-image, .blog-image {
        transition: transform 0.3s ease;
    }
    
    .card:hover .product-image,
    .card:hover .blog-image {
        transform: scale(1.05);
    }
</style>
@endpush
@endonce
@endif