<!-- resources/views/emails/inquiry-notification.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Inquiry Received</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: #2563eb;
            color: white;
            padding: 20px;
            border-radius: 5px 5px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 20px;
            border: 1px solid #dee2e6;
            border-radius: 0 0 5px 5px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .info-table td {
            padding: 10px;
            border-bottom: 1px solid #dee2e6;
        }
        .info-table td:first-child {
            font-weight: bold;
            width: 30%;
            background: #fff;
        }
        .message-box {
            background: white;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #2563eb;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 10px;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>New Inquiry Received</h2>
        <p>You have received a new inquiry from your website</p>
    </div>
    
    <div class="content">
        <h3>Contact Information</h3>
        <table class="info-table">
            <tr>
                <td>Name</td>
                <td>{{ $inquiry->name }}</td>
            </tr>
            <tr>
                <td>Email</td>
                <td><a href="mailto:{{ $inquiry->email }}">{{ $inquiry->email }}</a></td>
            </tr>
            <tr>
                <td>Phone</td>
                <td>{{ $inquiry->phone ?: 'Not provided' }}</td>
            </tr>
            <tr>
                <td>Company</td>
                <td>{{ $inquiry->company ?: 'Not provided' }}</td>
            </tr>
            <tr>
                <td>Country</td>
                <td>{{ $inquiry->country }}</td>
            </tr>
            <tr>
                <td>Subject</td>
                <td>{{ $inquiry->subject }}</td>
            </tr>
            @if($inquiry->product)
            <tr>
                <td>Product</td>
                <td>{{ $inquiry->product->name }}</td>
            </tr>
            @endif
        </table>
        
        <h3>Message</h3>
        <div class="message-box">
            {{ $inquiry->message }}
        </div>
        
        <div style="text-align: center;">
            <a href="{{ url('/admin/inquiries/' . $inquiry->id) }}" class="btn">View in Admin Panel</a>
        </div>
    </div>
    
    <div class="footer">
        <p>This is an automated email from your Export Portfolio website.</p>
        <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
    </div>
</body>
</html>