@extends('layouts.app')

@section('title', 'Lookbook - Style Inspiration')

@section('meta')
<meta name="description" content="Explore Edition By Punjab's lookbook featuring street culture, Punjabi fusion, sustainable style, and Australian streetwear collections.">
<meta name="keywords" content="streetwear lookbook, fashion inspiration, style guide, cultural fashion, sustainable streetwear, australian streetwear">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="lookbook-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 text-white fw-bold mb-4">Style Inspiration</h1>
                <p class="lead text-white mb-4">Discover how to style our pieces with our curated lookbook collections. From street culture to cultural fusion, find your perfect style inspiration.</p>
            </div>
            <div class="col-lg-6">
                <div class="hero-image text-center">
                    <x-lazy-image 
                        src="lookbooks/hero-collage.jpg" 
                        alt="Edition By Punjab Lookbook Collections"
                        class="img-fluid rounded shadow-lg"
                    />
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Lookbook Collections -->
<section class="lookbook-collections py-5">
    <div class="container">
        <div class="row">
            @foreach($lookbooks as $lookbook)
                <div class="col-md-6 mb-5">
                    <div class="lookbook-card h-100 border-0 shadow-sm overflow-hidden">
                        <div class="position-relative">
                            <x-lazy-image 
                                src="{{ $lookbook['image'] }}" 
                                alt="{{ $lookbook['title'] }}"
                                class="card-img-top lookbook-image"
                                style="height: 400px; object-fit: cover;"
                            />
                            <div class="lookbook-overlay d-flex align-items-end p-4">
                                <div class="text-white">
                                    <h3 class="mb-2">{{ $lookbook['title'] }}</h3>
                                    <p class="mb-3">{{ $lookbook['description'] }}</p>
                                    <a href="{{ route('lookbook.show', $lookbook['slug']) }}" class="btn btn-light">
                                        Explore Collection <i class="fas fa-arrow-right ms-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Featured Products Preview -->
                        <div class="card-body">
                            <h5 class="card-title mb-3">Featured Pieces</h5>
                            <div class="row g-2">
                                @foreach($lookbook['products']->take(3) as $product)
                                    <div class="col-4">
                                        <div class="product-preview">
                                            <x-lazy-image 
                                                :src="$product->featured_image ?? 'placeholder-product.jpg'" 
                                                :alt="$product->name"
                                                class="img-fluid rounded"
                                                style="height: 80px; object-fit: cover;"
                                            />
                                            <small class="text-muted d-block mt-1">{{ Str::limit($product->name, 15) }}</small>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="lookbook-cta py-5 bg-light">
    <div class="container text-center">
        <h2 class="mb-4">Ready to Create Your Look?</h2>
        <p class="lead mb-4">Shop our collections and create your own unique style story</p>
        <a href="{{ route('shop.index') }}" class="btn btn-primary btn-lg me-3">
            Shop Now <i class="fas fa-shopping-bag ms-2"></i>
        </a>
        <a href="{{ route('community.index') }}" class="btn btn-outline-primary btn-lg">
            Share Your Style <i class="fas fa-camera ms-2"></i>
        </a>
    </div>
</section>

@push('styles')
<style>
    .lookbook-hero {
        min-height: 500px;
        display: flex;
        align-items: center;
    }
    
    .lookbook-card {
        transition: transform 0.3s ease;
        border-radius: 1rem;
        overflow: hidden;
    }
    
    .lookbook-card:hover {
        transform: translateY(-5px);
    }
    
    .lookbook-image {
        transition: transform 0.5s ease;
    }
    
    .lookbook-card:hover .lookbook-image {
        transform: scale(1.05);
    }
    
    .lookbook-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .lookbook-card:hover .lookbook-overlay {
        opacity: 1;
    }
    
    .product-preview {
        transition: transform 0.2s ease;
    }
    
    .product-preview:hover {
        transform: scale(1.05);
    }
</style>
@endpush

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CollectionPage",
    "name": "Edition By Punjab Lookbook",
    "description": "Style inspiration and lookbook collections featuring streetwear, cultural fusion, and sustainable fashion",
    "url": "{{ route('lookbook.index') }}",
    "mainEntity": {
        "@type": "ItemList",
        "itemListElement": [
            @foreach($lookbooks as $index => $lookbook)
            {
                "@type": "CreativeWork",
                "position": {{ $index + 1 }},
                "name": "{{ $lookbook['title'] }}",
                "description": "{{ $lookbook['description'] }}",
                "url": "{{ route('lookbook.show', $lookbook['slug']) }}"
            }{{ !$loop->last ? ',' : '' }}
            @endforeach
        ]
    }
}
</script>
@endsection