<!-- resources/views/product-detail.blade.php -->
@extends('layouts.app')

@section('title', $product->meta_title ?: $product->name)
@section('meta_description', $product->meta_description ?: Str::limit($product->description, 160))
@section('meta_keywords', $product->meta_keywords)
@section('og_title', $product->name)
@section('og_description', Str::limit($product->description, 160))
@section('og_image', asset('storage/' . $product->featured_image))

@section('content')
<div class="container py-5">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('products') }}">Products</a></li>
            <li class="breadcrumb-item"><a href="{{ route('products', ['category' => $product->category->slug]) }}">{{ $product->category->name }}</a></li>
            <li class="breadcrumb-item active">{{ $product->name }}</li>
        </ol>
    </nav>

    <div class="row">
        <!-- Product Images -->
        <div class="col-lg-6 mb-4">
            <div class="product-gallery">
                <div class="main-image mb-3">
                    <img src="{{ asset('storage/' . $product->featured_image) }}" alt="{{ $product->name }}" class="img-fluid rounded" id="mainImage">
                </div>
                @if($product->gallery_images && count($product->gallery_images) > 0)
                <div class="gallery-thumbnails">
                    <div class="row g-2">
                        <div class="col-3">
                            <img src="{{ asset('storage/' . $product->featured_image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="img-fluid rounded cursor-pointer gallery-thumb active"
                                 onclick="changeImage(this.src)">
                        </div>
                        @foreach($product->gallery_images as $image)
                        <div class="col-3">
                            <img src="{{ asset('storage/' . $image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="img-fluid rounded cursor-pointer gallery-thumb"
                                 onclick="changeImage(this.src)">
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Product Details -->
        <div class="col-lg-6">
            <div class="product-details">
                <span class="badge bg-primary mb-2">{{ $product->category->name }}</span>
                @if($product->is_featured)
                <span class="badge bg-success mb-2">Featured</span>
                @endif
                
                <h1 class="h2 mb-3">{{ $product->name }}</h1>
                
                @if($product->sku)
                <p class="text-muted mb-3">SKU: {{ $product->sku }}</p>
                @endif

                @if($product->price)
                <div class="price mb-4">
                    <h3 class="text-primary">${{ number_format($product->price, 2) }}</h3>
                    <small class="text-muted">Price per unit</small>
                </div>
                @else
                <div class="alert alert-info mb-4">
                    <i class="fas fa-info-circle me-2"></i>Contact us for pricing information
                </div>
                @endif

                <div class="description mb-4">
                    <h5>Description</h5>
                    <p>{{ $product->description }}</p>
                </div>

                @if($product->specifications)
                <div class="specifications mb-4">
                    <h5>Specifications</h5>
                    <div class="bg-light p-3 rounded">
                        {!! nl2br(e($product->specifications)) !!}
                    </div>
                </div>
                @endif

                <!-- Inquiry Form -->
                <div class="inquiry-section">
                    <h5 class="mb-3">Interested in this product?</h5>
                    <button type="button" class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#inquiryModal">
                        <i class="fas fa-envelope me-2"></i>Send Inquiry
                    </button>
                    <a href="https://wa.me/1234567890?text=I'm interested in {{ urlencode($product->name) }}" 
                       target="_blank" 
                       class="btn btn-success btn-lg ms-2">
                        <i class="fab fa-whatsapp me-2"></i>WhatsApp
                    </a>
                </div>

                <!-- Share Buttons -->
                <div class="share-buttons mt-4">
                    <h6>Share this product:</h6>
                    <div class="btn-group">
                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(request()->url()) }}" 
                           target="_blank" 
                           class="btn btn-outline-primary">
                            <i class="fab fa-facebook"></i>
                        </a>
                        <a href="https://twitter.com/intent/tweet?url={{ urlencode(request()->url()) }}&text={{ urlencode($product->name) }}" 
                           target="_blank" 
                           class="btn btn-outline-info">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(request()->url()) }}" 
                           target="_blank" 
                           class="btn btn-outline-primary">
                            <i class="fab fa-linkedin"></i>
                        </a>
                        <a href="mailto:?subject={{ urlencode($product->name) }}&body={{ urlencode(request()->url()) }}" 
                           class="btn btn-outline-secondary">
                            <i class="fas fa-envelope"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Related Products -->
    @if($relatedProducts->count() > 0)
    <div class="related-products mt-5">
        <h3 class="mb-4">Related Products</h3>
        <div class="row g-4">
            @foreach($relatedProducts as $related)
            <div class="col-lg-3 col-md-6">
                <div class="card product-card h-100">
                    <img src="{{ asset('storage/' . $related->featured_image) }}" class="card-img-top" alt="{{ $related->name }}">
                    <div class="card-body">
                        <h5 class="card-title">{{ $related->name }}</h5>
                        <p class="card-text text-muted">{{ Str::limit($related->description, 80) }}</p>
                        <a href="{{ route('product.detail', $related->slug) }}" class="btn btn-outline-primary btn-sm">View Details</a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif
</div>

<!-- Inquiry Modal -->
<div class="modal fade" id="inquiryModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Send Inquiry for {{ $product->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('inquiry.submit') }}" method="POST">
                @csrf
                <input type="hidden" name="product_id" value="{{ $product->id }}">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Your Name *</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email Address *</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Phone Number</label>
                            <input type="tel" class="form-control" id="phone" name="phone">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="company" class="form-label">Company Name</label>
                            <input type="text" class="form-control" id="company" name="company">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="country" class="form-label">Country *</label>
                        <input type="text" class="form-control" id="country" name="country" required>
                    </div>
                    <div class="mb-3">
                        <label for="subject" class="form-label">Subject *</label>
                        <input type="text" class="form-control" id="subject" name="subject" value="Inquiry about {{ $product->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="message" class="form-label">Message *</label>
                        <textarea class="form-control" id="message" name="message" rows="4" required>I am interested in {{ $product->name }}. Please provide more information about pricing, minimum order quantity, and shipping options.</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Send Inquiry</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('styles')
<style>
    .gallery-thumb {
        cursor: pointer;
        opacity: 0.7;
        transition: opacity 0.3s;
    }
    .gallery-thumb:hover,
    .gallery-thumb.active {
        opacity: 1;
    }
    .share-buttons .btn {
        padding: 0.5rem 1rem;
    }
</style>
@endpush

@push('scripts')
<script>
function changeImage(src) {
    document.getElementById('mainImage').src = src;
    document.querySelectorAll('.gallery-thumb').forEach(thumb => {
        thumb.classList.remove('active');
        if(thumb.src === src) {
            thumb.classList.add('active');
        }
    });
}
</script>
@endpush
@endsection