<!-- resources/views/products.blade.php -->
@extends('layouts.app')

@section('title', 'Products')
@section('meta_description', 'Browse our complete catalog of export products')

@section('content')
<div class="container py-5">
    <div class="row">
        <!-- Sidebar Filters -->
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Search Products</h5>
                    <form method="GET" action="{{ route('products') }}">
                        <div class="mb-3">
                            <input type="text" name="search" class="form-control" placeholder="Search..." value="{{ request('search') }}">
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Search</button>
                    </form>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title">Categories</h5>
                    <div class="list-group list-group-flush">
                        <a href="{{ route('products') }}" class="list-group-item list-group-item-action {{ !request('category') ? 'active' : '' }}">
                            All Products
                        </a>
                        @foreach($categories as $category)
                        <a href="{{ route('products', ['category' => $category->slug]) }}" 
                           class="list-group-item list-group-item-action d-flex justify-content-between align-items-center {{ request('category') == $category->slug ? 'active' : '' }}">
                            {{ $category->name }}
                            <span class="badge bg-primary rounded-pill">{{ $category->activeProducts->count() }}</span>
                        </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="col-lg-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2>Our Products</h2>
                <div>
                    <span class="text-muted">Showing {{ $products->count() }} of {{ $products->total() }} products</span>
                </div>
            </div>

            <div class="row g-4">
                @forelse($products as $product)
                <div class="col-md-4" data-aos="fade-up">
                    <div class="card product-card h-100">
                        <img src="{{ asset('storage/' . $product->featured_image) }}" class="card-img-top" alt="{{ $product->name }}">
                        <div class="card-body d-flex flex-column">
                            <span class="badge bg-primary mb-2">{{ $product->category->name }}</span>
                            <h5 class="card-title">{{ $product->name }}</h5>
                            <p class="card-text text-muted flex-grow-1">{{ Str::limit($product->description, 100) }}</p>
                            @if($product->sku)
                            <p class="mb-2"><small class="text-muted">SKU: {{ $product->sku }}</small></p>
                            @endif
                            <div class="d-flex justify-content-between align-items-center mt-auto">
                                @if($product->price)
                                <span class="h5 mb-0 text-primary">${{ number_format($product->price, 2) }}</span>
                                @else
                                <span class="text-muted">Contact for price</span>
                                @endif
                                <a href="{{ route('product.detail', $product->slug) }}" class="btn btn-outline-primary btn-sm">
                                    View Details <i class="fas fa-arrow-right ms-1"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        <i class="fas fa-info-circle me-2"></i>No products found matching your criteria.
                    </div>
                </div>
                @endforelse
            </div>

            <!-- Pagination -->
            <div class="mt-5">
                {{ $products->withQueryString()->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection