@extends('layouts.app')

@section('title', 'Order Confirmed - #' . $order->order_number)

@section('content')
<div class="order-success-premium">
    <!-- Success Animation -->
    <section class="success-hero">
        <div class="container">
            <div class="success-content" data-aos="zoom-in">
                <div class="success-animation">
                    <div class="success-circle">
                        <i class="fas fa-check"></i>
                    </div>
                    <div class="success-ripple"></div>
                </div>
                
                <h1 class="success-title">ORDER CONFIRMED!</h1>
                <p class="success-message">Thank you for your purchase</p>
                
                <div class="order-number-display">
                    <span class="order-label">ORDER NUMBER</span>
                    <span class="order-value">#{{ $order->order_number }}</span>
                </div>
                
                <div class="success-actions">
                    <a href="{{ route('account.orders') }}" class="btn-success-primary">
                        VIEW MY ORDERS
                    </a>
                    <a href="{{ route('order.invoice', $order->order_number) }}" target="_blank" class="btn-success-secondary">
                        <i class="fas fa-download"></i>
                        DOWNLOAD INVOICE
                    </a>
                    <a href="{{ route('shop.index') }}" class="btn-success-outline">
                        CONTINUE SHOPPING
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Order Details -->
    <section class="order-details-section">
        <div class="container">
            <div class="row">
                <!-- Order Information -->
                <div class="col-lg-8">
                    <div class="order-card-premium" data-aos="fade-right">
                        <h3 class="card-header-premium">Order Details</h3>
                        
                        <div class="order-info-grid">
                            <div class="info-block">
                                <span class="info-label">Order Date</span>
                                <span class="info-value">{{ $order->created_at->format('F d, Y g:i A') }}</span>
                            </div>
                            <div class="info-block">
                                <span class="info-label">Payment Method</span>
                                <span class="info-value">{{ ucfirst($order->payment_method) }}</span>
                            </div>
                            <div class="info-block">
                                <span class="info-label">Payment Status</span>
                                <span class="info-value">
                                    <span class="status-badge {{ $order->payment_status }}">
                                        {{ ucfirst($order->payment_status) }}
                                    </span>
                                </span>
                            </div>
                            <div class="info-block">
                                <span class="info-label">Order Status</span>
                                <span class="info-value">
                                    <span class="status-badge {{ $order->status }}">
                                        {{ ucfirst(str_replace('_', ' ', $order->status)) }}
                                    </span>
                                </span>
                            </div>
                            @if($order->transaction_id)
                            <div class="info-block full-width">
                                <span class="info-label">Transaction ID</span>
                                <span class="info-value mono">{{ $order->transaction_id }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    <!-- Products Ordered -->
                    <div class="order-card-premium" data-aos="fade-right" data-aos-delay="100">
                        <h3 class="card-header-premium">Products Ordered</h3>
                        
                        <div class="products-list-premium">
                            @foreach($order->items as $item)
                            <div class="product-row-premium">
                                <div class="product-image">
                                    @if($item->product_image)
                                    <img src="{{ asset('storage/' . $item->product_image) }}" 
                                         alt="{{ $item->product_name }}">
                                    @else
                                    <div class="image-placeholder">
                                        <i class="fas fa-box"></i>
                                    </div>
                                    @endif
                                </div>
                                <div class="product-details">
                                    <h4>{{ $item->product_name }}</h4>
                                    @if($item->product_options)
                                        @php $options = json_decode($item->product_options, true); @endphp
                                        @if($options)
                                        <div class="product-options">
                                            @if(isset($options['size'])) 
                                                <span class="option-tag">Size: {{ $options['size'] }}</span>
                                            @endif
                                            @if(isset($options['color'])) 
                                                <span class="option-tag">Color: {{ $options['color'] }}</span>
                                            @endif
                                        </div>
                                        @endif
                                    @endif
                                </div>
                                <div class="product-qty">×{{ $item->quantity }}</div>
                                <div class="product-price">${{ number_format($item->price, 2) }}</div>
                                <div class="product-total">${{ number_format($item->subtotal, 2) }}</div>
                            </div>
                            @endforeach
                        </div>
                        
                        <!-- Order Totals -->
                        <div class="order-totals-premium">
                            <div class="total-row">
                                <span>Subtotal</span>
                                <span>${{ number_format($order->subtotal, 2) }}</span>
                            </div>
                            @if($order->discount_amount > 0)
                            <div class="total-row discount">
                                <span>Discount</span>
                                <span>-${{ number_format($order->discount_amount, 2) }}</span>
                            </div>
                            @endif
                            <div class="total-row">
                                <span>Tax</span>
                                <span>${{ number_format($order->tax_amount, 2) }}</span>
                            </div>
                            <div class="total-row">
                                <span>Shipping</span>
                                <span>
                                    @if($order->shipping_amount == 0)
                                        <span class="free-label">FREE</span>
                                    @else
                                        ${{ number_format($order->shipping_amount, 2) }}
                                    @endif
                                </span>
                            </div>
                            <div class="total-divider"></div>
                            <div class="total-row final">
                                <span>Total</span>
                                <span>${{ number_format($order->total_amount, 2) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Sidebar Information -->
                <div class="col-lg-4">
                    <!-- Shipping Information -->
                    <div class="info-card-premium" data-aos="fade-left">
                        <h4 class="info-card-title">Shipping Information</h4>
                        @if($order->shippingAddress)
                        <address class="shipping-address">
                            <strong>{{ $order->shippingAddress->first_name }} {{ $order->shippingAddress->last_name }}</strong><br>
                            {{ $order->shippingAddress->address_line_1 }}<br>
                            @if($order->shippingAddress->address_line_2)
                                {{ $order->shippingAddress->address_line_2 }}<br>
                            @endif
                            {{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }} {{ $order->shippingAddress->postal_code }}<br>
                            {{ $order->shippingAddress->country }}<br>
                            <br>
                            Phone: {{ $order->shippingAddress->phone }}
                        </address>
                        @endif
                        
                        <div class="estimated-delivery">
                            <i class="fas fa-truck"></i>
                            <span>Estimated Delivery: 5-7 business days</span>
                        </div>
                        
                        <a href="{{ route('order.track.index') }}" class="btn-track-order">
                            TRACK ORDER
                        </a>
                    </div>
                    
                    <!-- What's Next -->
                    <div class="info-card-premium" data-aos="fade-left" data-aos-delay="100">
                        <h4 class="info-card-title">What's Next?</h4>
                        <ul class="next-steps">
                            <li>
                                <i class="fas fa-envelope"></i>
                                <span>Order confirmation email sent</span>
                            </li>
                            <li>
                                <i class="fas fa-box"></i>
                                <span>We're preparing your order</span>
                            </li>
                            <li>
                                <i class="fas fa-shipping-fast"></i>
                                <span>Shipping notification coming soon</span>
                            </li>
                            <li>
                                <i class="fas fa-home"></i>
                                <span>Delivery to your address</span>
                            </li>
                        </ul>
                    </div>
                    
                    <!-- Need Help -->
                    <div class="help-card-premium" data-aos="fade-left" data-aos-delay="200">
                        <h4>Need Help?</h4>
                        <p>Our customer service team is here to assist you</p>
                        <a href="{{ route('contact') }}" class="btn-contact-support">
                            <i class="fas fa-headset"></i>
                            CONTACT SUPPORT
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@push('styles')
<style>
/* Order Success Styles */
.order-success-premium {
    min-height: 100vh;
    background: #fafafa;
}

/* Success Hero */
.success-hero {
    padding: 5rem 0;
    background: linear-gradient(135deg, #fff 0%, #f8f8f8 100%);
}

.success-content {
    text-align: center;
}

.success-animation {
    position: relative;
    width: 120px;
    height: 120px;
    margin: 0 auto 2rem;
}

.success-circle {
    width: 120px;
    height: 120px;
    background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 3rem;
    animation: scaleIn 0.5s ease-out;
}

.success-ripple {
    position: absolute;
    top: 0;
    left: 0;
    width: 120px;
    height: 120px;
    border: 2px solid #4CAF50;
    border-radius: 50%;
    animation: ripple 1.5s ease-out infinite;
}

@keyframes scaleIn {
    from {
        transform: scale(0);
        opacity: 0;
    }
    to {
        transform: scale(1);
        opacity: 1;
    }
}

@keyframes ripple {
    0% {
        transform: scale(1);
        opacity: 1;
    }
    100% {
        transform: scale(1.5);
        opacity: 0;
    }
}

.success-title {
    font-size: 2.5rem;
    font-weight: 900;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.success-message {
    font-size: 1.25rem;
    color: #666;
    margin-bottom: 2rem;
}

.order-number-display {
    display: inline-flex;
    flex-direction: column;
    padding: 1.5rem 3rem;
    background: white;
    border: 2px solid #e0e0e0;
    margin-bottom: 3rem;
}

.order-label {
    font-size: 0.75rem;
    color: #999;
    letter-spacing: 0.1em;
    margin-bottom: 0.5rem;
}

.order-value {
    font-size: 1.5rem;
    font-weight: 700;
    font-family: 'Space Grotesk', sans-serif;
}

.success-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-success-primary,
.btn-success-secondary,
.btn-success-outline {
    padding: 1rem 2rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    text-decoration: none;
    transition: all 0.3s;
}

.btn-success-primary {
    background: #000;
    color: white;
}

.btn-success-primary:hover {
    background: #333;
}

.btn-success-secondary {
    background: white;
    color: #000;
    border: 2px solid #000;
}

.btn-success-secondary:hover {
    background: #000;
    color: white;
}

.btn-success-outline {
    background: transparent;
    color: #666;
    border: 2px solid #e0e0e0;
}

.btn-success-outline:hover {
    border-color: #000;
    color: #000;
}

/* Order Details Section */
.order-details-section {
    padding: 3rem 0 5rem;
}

.order-card-premium {
    background: white;
    margin-bottom: 2rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.card-header-premium {
    padding: 1.5rem;
    border-bottom: 2px solid #f0f0f0;
    font-size: 1.125rem;
    font-weight: 700;
}

.order-info-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1.5rem;
    padding: 1.5rem;
}

.info-block {
    display: flex;
    flex-direction: column;
}

.info-block.full-width {
    grid-column: span 2;
}

.info-label {
    font-size: 0.875rem;
    color: #666;
    margin-bottom: 0.5rem;
}

.info-value {
    font-weight: 600;
}

.info-value.mono {
    font-family: monospace;
}

.status-badge {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    font-size: 0.75rem;
    font-weight: 600;
    letter-spacing: 0.05em;
    text-transform: uppercase;
    background: #e0e0e0;
}

.status-badge.paid {
    background: #4CAF50;
    color: white;
}

.status-badge.processing {
    background: #FF9800;
    color: white;
}

/* Products List */
.products-list-premium {
    padding: 1.5rem;
}

.product-row-premium {
    display: grid;
    grid-template-columns: 60px 1fr auto auto auto;
    gap: 1rem;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.product-row-premium:last-child {
    border-bottom: none;
}

.product-image img {
    width: 60px;
    height: 60px;
    object-fit: cover;
}

.image-placeholder {
    width: 60px;
    height: 60px;
    background: #f8f8f8;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
}

.product-details h4 {
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.product-options {
    display: flex;
    gap: 0.5rem;
}

.option-tag {
    padding: 0.25rem 0.5rem;
    background: #f0f0f0;
    font-size: 0.75rem;
}

.product-qty {
    font-weight: 600;
}

.product-price {
    color: #666;
}

.product-total {
    font-weight: 700;
}

/* Order Totals */
.order-totals-premium {
    padding: 1.5rem;
    background: #f8f8f8;
}

.total-row {
    display: flex;
    justify-content: space-between;
    padding: 0.5rem 0;
}

.total-row.discount {
    color: #4CAF50;
}

.total-row.final {
    font-size: 1.125rem;
    font-weight: 700;
}

.free-label {
    color: #4CAF50;
    font-weight: 600;
}

.total-divider {
    height: 1px;
    background: #e0e0e0;
    margin: 1rem 0;
}

/* Info Cards */
.info-card-premium {
    background: white;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.info-card-title {
    font-size: 1rem;
    font-weight: 700;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f0f0f0;
}

.shipping-address {
    font-style: normal;
    line-height: 1.8;
    color: #666;
}

.estimated-delivery {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem;
    background: #f8f8f8;
    margin: 1rem 0;
}

.btn-track-order {
    display: block;
    width: 100%;
    padding: 0.75rem;
    background: #000;
    color: white;
    text-align: center;
    text-decoration: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    transition: all 0.3s;
}

.btn-track-order:hover {
    background: #333;
}

.next-steps {
    list-style: none;
    padding: 0;
}

.next-steps li {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.next-steps li:last-child {
    border-bottom: none;
}

.next-steps i {
    color: #4CAF50;
}

/* Help Card */
.help-card-premium {
    background: linear-gradient(135deg, #000 0%, #333 100%);
    color: white;
    padding: 1.5rem;
    text-align: center;
}

.help-card-premium h4 {
    margin-bottom: 0.5rem;
}

.help-card-premium p {
    opacity: 0.9;
    margin-bottom: 1rem;
}

.btn-contact-support {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: white;
    color: #000;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
}

.btn-contact-support:hover {
    transform: translateY(-2px);
}

/* Dashboard Styles */
.dashboard-premium {
    padding: 2rem 0;
    min-height: calc(100vh - 200px);
}

.dashboard-header-premium {
    padding: 2rem 0;
    background: linear-gradient(135deg, #f8f8f8 0%, #fff 100%);
}

.dashboard-title {
    font-size: 2rem;
    font-weight: 900;
    margin-bottom: 0.5rem;
    font-family: 'Space Grotesk', sans-serif;
}

.dashboard-welcome {
    color: #666;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 3rem;
}

.stat-card-premium {
    background: white;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1.5rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    transition: all 0.3s;
}

.stat-card-premium:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.stat-icon.orders {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.stat-icon.wishlist {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.stat-icon.rewards {
    background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    color: white;
}

.stat-icon.reviews {
    background: linear-gradient(135deg, #30cfd0 0%, #330867 100%);
    color: white;
}

.stat-content {
    display: flex;
    flex-direction: column;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.875rem;
    color: #666;
}

/* Quick Actions Grid */
.quick-actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 1rem;
    margin-bottom: 3rem;
}

.action-card-premium {
    background: white;
    padding: 2rem 1rem;
    text-align: center;
    text-decoration: none;
    color: #000;
    transition: all 0.3s;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.action-card-premium:hover {
    background: #000;
    color: white;
    transform: translateY(-5px);
}

.action-card-premium i {
    font-size: 2rem;
    margin-bottom: 1rem;
    display: block;
}

/* Recent Orders Section */
.recent-orders-section {
    background: white;
    padding: 2rem;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.section-header-dashboard {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #f0f0f0;
}

.section-header-dashboard h3 {
    font-size: 1.25rem;
    font-weight: 700;
}

.section-header-dashboard a {
    color: #666;
    text-decoration: none;
    font-weight: 600;
}

.section-header-dashboard a:hover {
    color: #000;
}

.order-row-dashboard {
    display: grid;
    grid-template-columns: 2fr 1fr 1fr 1fr;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid #f0f0f0;
}

.order-row-dashboard:last-child {
    border-bottom: none;
}

.order-info {
    display: flex;
    flex-direction: column;
}

.order-number {
    font-weight: 600;
    margin-bottom: 0.25rem;
}

.order-date {
    font-size: 0.875rem;
    color: #666;
}

.order-actions {
    display: flex;
    gap: 0.5rem;
}

.btn-view,
.btn-track {
    padding: 0.5rem 1rem;
    background: #f8f8f8;
    color: #000;
    text-decoration: none;
    font-size: 0.875rem;
    font-weight: 600;
    transition: all 0.3s;
}

.btn-view:hover,
.btn-track:hover {
    background: #000;
    color: white;
}

/* Responsive */
@media (max-width: 768px) {
    .success-title {
        font-size: 1.75rem;
    }
    
    .success-actions {
        flex-direction: column;
    }
    
    .order-info-grid {
        grid-template-columns: 1fr;
    }
    
    .product-row-premium {
        grid-template-columns: 60px 1fr;
        gap: 0.5rem;
    }
    
    .product-qty,
    .product-price,
    .product-total {
        grid-column: span 2;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .quick-actions-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .order-row-dashboard {
        grid-template-columns: 1fr;
        gap: 0.5rem;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Animate success checkmark on load
document.addEventListener('DOMContentLoaded', function() {
    const successCircle = document.querySelector('.success-circle');
    if (successCircle) {
        setTimeout(() => {
            successCircle.classList.add('animated');
        }, 100);
    }
});
</script>
@endpush
@endsection