<div class="row">
    <div class="col-md-6">
        <img src="{{ Storage::url($product->featured_image) }}" 
             alt="{{ $product->name }}" 
             class="img-fluid rounded"
             onerror="this.src='/images/placeholder-product.jpg'">
    </div>
    <div class="col-md-6">
        <h4>{{ $product->name }}</h4>
        <p class="text-muted">{{ $product->category->name }}</p>
        
        @if($product->sku)
        <p class="small">SKU: {{ $product->sku }}</p>
        @endif
        
        <div class="price mb-3">
            @if($product->compare_price && $product->compare_price > $product->price)
            <span class="text-muted text-decoration-line-through me-2">
                ${{ number_format($product->compare_price, 2) }}
            </span>
            @endif
            <span class="h4 text-primary">${{ number_format($product->price, 2) }}</span>
        </div>
        
        <p>{{ Str::limit($product->description, 150) }}</p>
        
        @if($product->stock > 0)
        <form action="{{ route('cart.add') }}" method="POST" class="quick-add-form">
            @csrf
            <input type="hidden" name="product_id" value="{{ $product->id }}">
            
            @if($sizes && count($sizes) > 0)
            <div class="mb-3">
                <label class="form-label">Size</label>
                <select name="size" class="form-select" required>
                    <option value="">Select Size</option>
                    @foreach($sizes as $size)
                    <option value="{{ $size }}">{{ $size }}</option>
                    @endforeach
                </select>
            </div>
            @endif
            
            @if($colors && count($colors) > 0)
            <div class="mb-3">
                <label class="form-label">Color</label>
                <select name="color" class="form-select" required>
                    <option value="">Select Color</option>
                    @foreach($colors as $color)
                    <option value="{{ $color }}">{{ $color }}</option>
                    @endforeach
                </select>
            </div>
            @endif
            
            <div class="mb-3">
                <label class="form-label">Quantity</label>
                <input type="number" name="quantity" value="1" min="1" max="{{ $product->stock }}" class="form-control">
            </div>
            
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-shopping-cart"></i> Add to Cart
                </button>
                <a href="{{ route('shop.product', $product->slug) }}" class="btn btn-outline-secondary">
                    View Full Details
                </a>
            </div>
        </form>
        @else
        <div class="alert alert-danger">Out of Stock</div>
        <a href="{{ route('shop.product', $product->slug) }}" class="btn btn-primary">
            View Details
        </a>
        @endif
    </div>
</div>

<script>
document.querySelector('.quick-add-form')?.addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update cart count
            document.querySelectorAll('.cart-count').forEach(el => {
                el.textContent = data.cartCount || 0;
            });
            
            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('quickViewModal'));
            modal?.hide();
            
            // Show success message
            alert('Product added to cart!');
        }
    })
    .catch(() => {
        // Fallback to normal submission
        this.submit();
    });
});
</script>