@extends('layouts.app')

@section('title', $guide['meta_title'])

@section('meta')
<meta name="description" content="{{ $guide['meta_description'] }}">
<meta name="keywords" content="{{ $guide['keywords'] }}">
@endsection

@section('content')
<x-breadcrumb />

<!-- Hero Section -->
<section class="city-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('{{ asset('images/' . $guide['hero_image']) }}'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="city-intro text-white">
                    <div class="city-meta mb-3">
                        <span class="badge bg-primary me-2">{{ $guide['region'] }}</span>
                        <span class="badge bg-light text-dark">{{ $guide['climate'] }}</span>
                    </div>
                    <h1 class="display-3 fw-bold mb-4">{{ $guide['name'] }}</h1>
                    <p class="lead mb-4">{{ $guide['tagline'] }}</p>
                    <p class="mb-4">{{ $guide['description'] }}</p>
                    <div class="city-stats d-flex gap-4">
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0">{{ $guide['population'] }}</div>
                            <small>Population</small>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0">{{ $guide['fashion_score'] }}/10</div>
                            <small>Fashion Scene</small>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0">{{ $guide['streetwear_popularity'] }}%</div>
                            <small>Streetwear Pop.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Style Breakdown -->
<section class="style-breakdown py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <h2 class="mb-4">The {{ $guide['name'] }} Style DNA</h2>
                <div class="style-characteristics mb-5">
                    @foreach($guide['style_characteristics'] as $characteristic)
                        <div class="characteristic-item mb-4 p-4 bg-light rounded">
                            <h5 class="text-primary mb-2">{{ $characteristic['title'] }}</h5>
                            <p class="mb-0">{{ $characteristic['description'] }}</p>
                        </div>
                    @endforeach
                </div>

                <!-- Key Pieces -->
                <div class="key-pieces mb-5">
                    <h3 class="mb-4">Essential {{ $guide['name'] }} Pieces</h3>
                    <div class="row g-3">
                        @foreach($guide['key_pieces'] as $piece)
                            <div class="col-md-6">
                                <div class="piece-item d-flex align-items-center p-3 bg-white border rounded">
                                    <div class="piece-icon me-3">
                                        <i class="fas fa-tshirt text-primary fa-lg"></i>
                                    </div>
                                    <div class="piece-info">
                                        <h6 class="mb-1">{{ $piece }}</h6>
                                        <small class="text-muted">Perfect for {{ strtolower($guide['name']) }} lifestyle</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Seasonal Styling -->
                <div class="seasonal-styling mb-5">
                    <h3 class="mb-4">Year-Round {{ $guide['name'] }} Styling</h3>
                    <div class="seasons-grid">
                        @foreach($guide['seasonal_styling'] as $season => $styling)
                            <div class="season-card mb-4 p-4 border rounded">
                                <h5 class="season-title mb-3">
                                    <i class="fas fa-{{ $styling['icon'] }} text-primary me-2"></i>
                                    {{ $styling['season'] }}
                                </h5>
                                <p class="season-description mb-3">{{ $styling['description'] }}</p>
                                <div class="season-tips">
                                    <h6 class="mb-2">Key Tips:</h6>
                                    <ul class="mb-0">
                                        @foreach($styling['tips'] as $tip)
                                            <li>{{ $tip }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Local Influences -->
                <div class="local-influences mb-5">
                    <h3 class="mb-4">{{ $guide['name'] }} Cultural Influences</h3>
                    <div class="influences-grid">
                        @foreach($guide['cultural_influences'] as $influence)
                            <div class="influence-item mb-3 p-4 bg-gradient-light rounded">
                                <h6 class="fw-bold mb-2">{{ $influence['aspect'] }}</h6>
                                <p class="mb-0">{{ $influence['description'] }}</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="city-sidebar">
                    <!-- Color Palette -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">{{ $guide['name'] }} Color Palette</h5>
                            <div class="color-palette mb-3">
                                <div class="row g-2">
                                    @foreach($guide['color_palette'] as $color)
                                        <div class="col-6 text-center">
                                            <div class="color-swatch mx-auto mb-2 rounded-circle" 
                                                 style="width: 50px; height: 50px; background-color: {{ $color['hex'] }};"></div>
                                            <small class="d-block">{{ $color['name'] }}</small>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <small class="text-muted">These colors reflect {{ strtolower($guide['name']) }}'s natural beauty and urban energy.</small>
                        </div>
                    </div>

                    <!-- Best Shopping Areas -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Best Shopping Areas</h5>
                            <ul class="list-unstyled mb-0">
                                @foreach($guide['shopping_areas'] as $area)
                                    <li class="mb-2">
                                        <i class="fas fa-map-marker-alt text-primary me-2"></i>
                                        <strong>{{ $area['name'] }}</strong>
                                        <small class="d-block text-muted ms-3">{{ $area['description'] }}</small>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                    <!-- Weather Considerations -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Weather & Style</h5>
                            <div class="weather-info">
                                <div class="weather-stat mb-2">
                                    <strong>Average Temperature:</strong> {{ $guide['weather']['avg_temp'] }}
                                </div>
                                <div class="weather-stat mb-2">
                                    <strong>Rainfall:</strong> {{ $guide['weather']['rainfall'] }}
                                </div>
                                <div class="weather-stat mb-3">
                                    <strong>Best Months:</strong> {{ $guide['weather']['best_months'] }}
                                </div>
                                <small class="text-muted">{{ $guide['weather']['style_note'] }}</small>
                            </div>
                        </div>
                    </div>

                    <!-- Call to Action -->
                    <div class="card">
                        <div class="card-body text-center">
                            <h5 class="card-title">Shop {{ $guide['name'] }} Style</h5>
                            <p class="card-text">Get the perfect pieces for {{ strtolower($guide['name']) }} streetwear.</p>
                            <a href="{{ route('shop.index') }}" class="btn btn-primary w-100 mb-2">
                                Shop Collection
                            </a>
                            <a href="{{ route('community.submit') }}" class="btn btn-outline-primary w-100">
                                Share Your Look
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Style Gallery -->
<section class="style-gallery py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center">{{ $guide['name'] }} Street Style Inspiration</h3>
                <div class="row g-4">
                    @foreach($guide['style_gallery'] as $look)
                        <div class="col-md-3 col-sm-6">
                            <div class="gallery-item position-relative">
                                <x-lazy-image 
                                    src="{{ $look['image'] }}" 
                                    alt="{{ $look['description'] }}"
                                    class="img-fluid rounded"
                                    style="height: 300px; object-fit: cover;"
                                />
                                <div class="gallery-overlay position-absolute bottom-0 start-0 end-0 p-3 text-white">
                                    <small class="d-block opacity-90">{{ $look['description'] }}</small>
                                    <span class="badge bg-primary">{{ $look['style_type'] }}</span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Cities -->
<section class="related-cities py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center">Explore Other Australian Cities</h3>
                <div class="row g-4">
                    @foreach($relatedCities as $citySlug => $relatedCity)
                        <div class="col-md-4">
                            <div class="related-city-card h-100 bg-white rounded shadow-sm">
                                <x-lazy-image 
                                    src="{{ $relatedCity['image'] }}" 
                                    alt="{{ $relatedCity['name'] }} Style Guide"
                                    class="card-img-top rounded-top"
                                    style="height: 200px; object-fit: cover;"
                                />
                                <div class="card-body">
                                    <h5 class="card-title">{{ $relatedCity['name'] }}</h5>
                                    <p class="card-text">{{ $relatedCity['description'] }}</p>
                                    <a href="{{ route('style-guide.show', $citySlug) }}" class="btn btn-outline-primary">
                                        Explore Style Guide
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>

@push('styles')
<style>
    .city-hero {
        min-height: 600px;
        display: flex;
        align-items: center;
    }
    
    .characteristic-item {
        border-left: 4px solid #007bff;
    }
    
    .piece-item {
        transition: transform 0.2s ease;
    }
    
    .piece-item:hover {
        transform: translateX(5px);
    }
    
    .season-card {
        transition: box-shadow 0.3s ease;
    }
    
    .season-card:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .color-swatch {
        border: 3px solid #fff;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    
    .gallery-item {
        border-radius: 0.5rem;
        overflow: hidden;
        transition: transform 0.3s ease;
    }
    
    .gallery-item:hover {
        transform: scale(1.05);
    }
    
    .gallery-overlay {
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
    }
    
    .bg-gradient-light {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .related-city-card {
        transition: transform 0.3s ease;
    }
    
    .related-city-card:hover {
        transform: translateY(-5px);
    }
</style>
@endpush

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Article",
    "headline": "{{ $guide['name'] }} Street Style Guide",
    "description": "{{ $guide['description'] }}",
    "image": "{{ asset('images/' . $guide['hero_image']) }}",
    "author": {
        "@type": "Organization",
        "name": "Edition By Punjab"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "{{ route('home') }}"
    },
    "datePublished": "{{ now()->toISOString() }}",
    "dateModified": "{{ now()->toISOString() }}",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "{{ route('style-guide.show', $city) }}"
    },
    "about": {
        "@type": "Place",
        "name": "{{ $guide['name'] }}",
        "description": "{{ $guide['description'] }}"
    }
}
</script>
@endsection