@extends('layouts.app')

@section('title', 'Fashion News & Updates - Edition By Punjab')

@section('content')
<div class="container-fluid px-0">
    <!-- Hero Section -->
    <section class="fashion-news-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4">Fashion News & Updates</h1>
                        <p class="lead mb-4">Stay informed with the latest news, updates, and developments in the Australian fashion industry</p>
                        <div class="hero-stats d-flex justify-content-center gap-5 mt-4">
                            <div class="stat-item">
                                <h3 class="fw-bold">{{ count($fashionNews) }}</h3>
                                <p class="mb-0">Latest Articles</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">{{ date('M') }}</h3>
                                <p class="mb-0">{{ date('Y') }} Updates</p>
                            </div>
                            <div class="stat-item">
                                <h3 class="fw-bold">24/7</h3>
                                <p class="mb-0">Coverage</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured News Section -->
    <section class="featured-news py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header text-center mb-5">
                        <h2 class="display-5 fw-bold text-dark">Latest Fashion News</h2>
                        <p class="lead text-muted">Breaking news and industry updates from the fashion world</p>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                @foreach($fashionNews as $index => $article)
                <div class="col-lg-4 col-md-6">
                    <article class="news-card card border-0 shadow-sm h-100 overflow-hidden">
                        <div class="news-image position-relative">
                            <img src="{{ asset('storage/' . $article['image']) }}" 
                                 class="card-img-top" 
                                 alt="{{ $article['title'] }}"
                                 style="height: 250px; object-fit: cover;">
                            
                            <!-- Category Badge -->
                            <div class="category-badge position-absolute top-0 start-0 m-3">
                                @if($article['category'] === 'Brand News')
                                    <span class="badge bg-primary px-3 py-2 rounded-pill">
                                        <i class="fas fa-building me-1"></i>{{ $article['category'] }}
                                    </span>
                                @elseif($article['category'] === 'Industry News')
                                    <span class="badge bg-success px-3 py-2 rounded-pill">
                                        <i class="fas fa-industry me-1"></i>{{ $article['category'] }}
                                    </span>
                                @else
                                    <span class="badge bg-warning text-dark px-3 py-2 rounded-pill">
                                        <i class="fas fa-globe me-1"></i>{{ $article['category'] }}
                                    </span>
                                @endif
                            </div>

                            <!-- Read Time -->
                            <div class="read-time position-absolute top-0 end-0 m-3">
                                <span class="badge bg-dark px-3 py-2 rounded-pill">
                                    <i class="fas fa-clock me-1"></i>{{ $article['read_time'] }} min
                                </span>
                            </div>
                        </div>
                        
                        <div class="card-body p-4 d-flex flex-column">
                            <!-- Publication Date -->
                            <div class="news-meta mb-3">
                                <small class="text-muted">
                                    <i class="fas fa-calendar me-2"></i>
                                    {{ date('F j, Y', strtotime($article['published_date'])) }}
                                </small>
                            </div>

                            <!-- Title -->
                            <h4 class="card-title fw-bold text-dark mb-3">{{ $article['title'] }}</h4>
                            
                            <!-- Excerpt -->
                            <p class="card-text text-muted mb-4 flex-grow-1">{{ $article['excerpt'] }}</p>

                            <!-- Action Buttons -->
                            <div class="news-actions">
                                <a href="{{ route('trends.news.story', $article['slug']) }}" class="btn btn-primary">
                                    <i class="fas fa-newspaper me-2"></i>Read Full Story
                                </a>
                                <button class="btn btn-outline-secondary ms-2" onclick="shareArticle('{{ $article['title'] }}', '{{ route('trends.news.story', $article['slug']) }}')">
                                    <i class="fas fa-share-alt"></i>
                                </button>
                            </div>
                        </div>
                    </article>
                </div>
                @endforeach
            </div>
        </div>
    </section>

    <!-- News Categories Section -->
    <section class="news-categories py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center mb-5 fw-bold">Browse News by Category</h3>
                </div>
            </div>
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <div class="category-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-building fa-3x text-primary"></i>
                        </div>
                        <h5 class="fw-bold">Brand News</h5>
                        <p class="text-muted mb-3">Updates from Edition By Punjab and other fashion brands</p>
                        <span class="badge bg-primary">{{ collect($fashionNews)->where('category', 'Brand News')->count() }} Articles</span>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="category-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-industry fa-3x text-success"></i>
                        </div>
                        <h5 class="fw-bold">Industry News</h5>
                        <p class="text-muted mb-3">Fashion industry trends, reports, and insights</p>
                        <span class="badge bg-success">{{ collect($fashionNews)->where('category', 'Industry News')->count() }} Articles</span>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="category-card text-center p-4 border rounded-3 h-100">
                        <div class="icon mb-3">
                            <i class="fas fa-globe fa-3x text-warning"></i>
                        </div>
                        <h5 class="fw-bold">Global Trends</h5>
                        <p class="text-muted mb-3">International fashion movements and cultural influences</p>
                        <span class="badge bg-warning text-dark">{{ collect($fashionNews)->where('category', 'Global Trends')->count() }} Articles</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Subscription -->
    <section class="newsletter-section py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h3 class="fw-bold mb-3">Stay Updated with Fashion News</h3>
                    <p class="lead mb-4">Subscribe to our newsletter and never miss the latest fashion updates</p>
                    <form class="newsletter-form d-flex gap-3 justify-content-center">
                        <div class="flex-grow-1" style="max-width: 400px;">
                            <input type="email" class="form-control form-control-lg" placeholder="Enter your email address" required>
                        </div>
                        <button type="submit" class="btn btn-light btn-lg px-4">
                            <i class="fas fa-paper-plane me-2"></i>Subscribe
                        </button>
                    </form>
                    <small class="mt-3 d-block opacity-75">We respect your privacy. Unsubscribe at any time.</small>
                </div>
            </div>
        </div>
    </section>

    <!-- Navigation Section -->
    <section class="trends-navigation py-5 bg-dark text-white">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h3 class="mb-5 fw-bold">Explore More Content</h3>
                </div>
            </div>
            <div class="row g-4 text-center">
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-chart-trending-up fa-3x mb-3 text-warning"></i>
                        <h5 class="fw-bold">Weekly Trends</h5>
                        <p class="text-muted">Latest weekly streetwear trends</p>
                        <a href="{{ route('trends.weekly') }}" class="btn btn-outline-warning">View Trends</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-calendar-alt fa-3x mb-3 text-info"></i>
                        <h5 class="fw-bold">Seasonal Forecast</h5>
                        <p class="text-muted">Upcoming seasonal trends</p>
                        <a href="{{ route('trends.seasonal') }}" class="btn btn-outline-info">View Forecast</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-crystal-ball fa-3x mb-3 text-danger"></i>
                        <h5 class="fw-bold">Style Predictions</h5>
                        <p class="text-muted">Future fashion forecasts</p>
                        <a href="{{ route('trends.predictions') }}" class="btn btn-outline-danger">See Predictions</a>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <a href="{{ route('trends.index') }}" class="btn btn-outline-light btn-lg px-5 rounded-pill">
                        <i class="fas fa-arrow-left me-2"></i> Back to Trends Overview
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.news-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.news-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.1) !important;
}

.category-card {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.category-card:hover {
    transform: translateY(-3px);
    border-color: #3b82f6 !important;
}

.nav-item {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.nav-item:hover {
    transform: translateY(-5px);
    border-color: #fff !important;
}

.category-badge .badge,
.read-time .badge {
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
}

.fashion-news-hero {
    position: relative;
    overflow: hidden;
}

.fashion-news-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.1);
    z-index: 1;
}

.fashion-news-hero .container {
    position: relative;
    z-index: 2;
}

.newsletter-form input:focus {
    box-shadow: 0 0 0 0.2rem rgba(255,255,255,0.25);
    border-color: #fff;
}
</style>

<script>
function shareArticle(title, url) {
    if (navigator.share) {
        navigator.share({
            title: title,
            url: url
        });
    } else {
        // Fallback for browsers that don't support Web Share API
        navigator.clipboard.writeText(url).then(() => {
            alert('Article URL copied to clipboard!');
        });
    }
}
</script>
@endsection