<?php $__env->startSection('title', $cityData['meta_title']); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($cityData['meta_description']); ?>">
<meta name="keywords" content="<?php echo e($cityData['keywords']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="city-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('<?php echo e(asset('images/cities/melbourne-streetwear-hero.jpg')); ?>'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="hero-content text-white">
                    <div class="city-badge mb-3">
                        <span class="badge bg-primary me-2"><?php echo e($cityData['name']); ?></span>
                        <span class="badge bg-light text-dark">Australia's Cultural Capital</span>
                    </div>
                    <h1 class="display-3 fw-bold mb-4"><?php echo e($cityData['hero_title']); ?></h1>
                    <p class="h4 mb-4 text-light"><?php echo e($cityData['hero_subtitle']); ?></p>
                    <p class="lead mb-4"><?php echo e($cityData['hero_description']); ?></p>
                    
                    <div class="city-stats row g-3 mb-4">
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1"><?php echo e($cityData['population']); ?></div>
                                <small>Population</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1"><?php echo e(count($cityData['fashion_districts'])); ?></div>
                                <small>Fashion Districts</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1"><?php echo e($cityData['cultural_diversity']); ?></div>
                                <small>Cultural Diversity</small>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="stat-card text-center p-3 bg-white bg-opacity-10 rounded">
                                <div class="stat-number h4 mb-1"><?php echo e($cityData['streetwear_growth']); ?></div>
                                <small>Streetwear Growth</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="hero-actions">
                        <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary btn-lg me-3">
                            Shop Melbourne Collection <i class="fas fa-shopping-bag ms-2"></i>
                        </a>
                        <a href="#fashion-districts" class="btn btn-outline-light btn-lg">
                            Explore Districts <i class="fas fa-map-marker-alt ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- City Introduction -->
<section class="city-intro py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="mb-4">Melbourne: Australia's Streetwear Capital</h2>
                <p class="lead"><?php echo e($cityData['city_intro']); ?></p>
            </div>
        </div>
    </div>
</section>

<!-- Fashion Districts -->
<section id="fashion-districts" class="fashion-districts py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Melbourne's Fashion Districts</h2>
                <p class="text-center text-muted">Discover where Melbourne's streetwear culture thrives</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $cityData['fashion_districts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6">
                    <div class="district-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="district-header mb-3">
                            <h4 class="district-name mb-2"><?php echo e($district['name']); ?></h4>
                            <span class="badge bg-primary"><?php echo e($district['vibe']); ?></span>
                        </div>
                        <p class="district-description mb-3"><?php echo e($district['description']); ?></p>
                        <div class="district-best-for">
                            <strong>Best for:</strong> <?php echo e($district['best_for']); ?>

                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Style Characteristics -->
<section class="style-characteristics py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="text-center mb-5">What Makes Melbourne Style Unique</h2>
                <div class="characteristics-grid">
                    <?php $__currentLoopData = $cityData['style_characteristics']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $characteristic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="characteristic-item mb-4 p-4 border-start border-primary border-4 bg-light">
                            <h5 class="text-primary mb-2"><?php echo e($characteristic['title']); ?></h5>
                            <p class="mb-0"><?php echo e($characteristic['description']); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Local Trends -->
<section class="local-trends py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Trending Now in Melbourne</h2>
                <p class="text-center text-muted">The hottest streetwear trends taking over Melbourne streets</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $cityData['local_trends']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6">
                    <div class="trend-card h-100 bg-white rounded-lg shadow-sm p-4">
                        <div class="trend-header d-flex justify-content-between align-items-center mb-3">
                            <h5 class="trend-name mb-0"><?php echo e($trend['trend']); ?></h5>
                            <div class="popularity-score">
                                <span class="badge bg-success"><?php echo e($trend['popularity']); ?>% Popular</span>
                            </div>
                        </div>
                        <p class="trend-description mb-0"><?php echo e($trend['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Why Edition By Punjab Fits Melbourne -->
<section class="why-we-fit py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h2 class="mb-4">Why Edition By Punjab Fits Melbourne</h2>
                <p class="lead mb-4">Our cultural fusion streetwear aligns perfectly with Melbourne's diverse and creative fashion scene.</p>
                
                <ul class="list-unstyled">
                    <?php $__currentLoopData = $cityData['why_edition_fits']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-primary me-3 mt-1"></i>
                            <span><?php echo e($reason); ?></span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                
                <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary btn-lg">
                    Shop Melbourne Collection <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
            <div class="col-lg-6">
                <div class="image-grid">
                    <div class="row g-3">
                        <div class="col-6">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'cities/melbourne-style-1.jpg','alt' => 'Melbourne Streetwear Style','class' => 'img-fluid rounded'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        </div>
                        <div class="col-6">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'cities/melbourne-style-2.jpg','alt' => 'Cultural Fashion Melbourne','class' => 'img-fluid rounded'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        </div>
                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'cities/melbourne-cultural-streetwear.jpg','alt' => 'Edition By Punjab Melbourne','class' => 'img-fluid rounded'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Featured Products for Melbourne -->
<section class="featured-products py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12 mb-5">
                <h2 class="text-center mb-4">Perfect for Melbourne Streets</h2>
                <p class="text-center text-muted">Handpicked pieces ideal for Melbourne's unique style and climate</p>
            </div>
        </div>
        
        <div class="row g-4">
            <?php $__currentLoopData = $relatedProducts->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-6">
                    <div class="product-card h-100 bg-white rounded shadow-sm overflow-hidden">
                        <div class="product-image-wrapper position-relative">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => $product->featured_image ?? 'placeholder-product.jpg','alt' => $product->name,'class' => 'img-fluid w-100','style' => 'height: 250px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                            <div class="product-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-center justify-content-center opacity-0">
                                <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="btn btn-primary">
                                    Shop Now
                                </a>
                            </div>
                        </div>
                        <div class="product-info p-3">
                            <h6 class="product-name mb-2"><?php echo e($product->name); ?></h6>
                            <div class="product-price fw-bold text-primary">
                                $<?php echo e(number_format($product->price, 2)); ?>

                            </div>
                            <small class="text-muted">Perfect for Melbourne weather</small>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Local SEO Keywords -->
<section class="local-seo py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h3 class="mb-4">Finding Streetwear in Melbourne</h3>
                <p class="text-muted mb-4">Popular searches for Melbourne streetwear enthusiasts</p>
                <div class="seo-tags">
                    <?php $__currentLoopData = $cityData['local_seo_terms']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-light text-dark me-2 mb-2 p-2"><?php echo e($term); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .city-hero {
        min-height: 700px;
        display: flex;
        align-items: center;
    }
    
    .district-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .district-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }
    
    .characteristic-item {
        transition: transform 0.2s ease;
    }
    
    .characteristic-item:hover {
        transform: translateX(5px);
    }
    
    .trend-card {
        transition: transform 0.3s ease;
    }
    
    .trend-card:hover {
        transform: translateY(-5px);
    }
    
    .product-card {
        transition: transform 0.3s ease;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
    }
    
    .product-overlay {
        background: rgba(0,0,0,0.7);
        transition: opacity 0.3s ease;
    }
    
    .product-card:hover .product-overlay {
        opacity: 1 !important;
    }
    
    .rounded-lg {
        border-radius: 1rem;
    }
    
    .seo-tags .badge {
        font-size: 0.9rem;
    }
    
    .stat-card {
        backdrop-filter: blur(10px);
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "<?php echo e($cityData['hero_title']); ?>",
    "description": "<?php echo e($cityData['meta_description']); ?>",
    "url": "<?php echo e(route('city.melbourne')); ?>",
    "mainEntity": {
        "@type": "Place",
        "name": "Melbourne",
        "description": "<?php echo e($cityData['city_intro']); ?>",
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": "-37.8136",
            "longitude": "144.9631"
        }
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "breadcrumb": {
        "@type": "BreadcrumbList",
        "itemListElement": [
            {
                "@type": "ListItem",
                "position": 1,
                "name": "Home",
                "item": "<?php echo e(route('home')); ?>"
            },
            {
                "@type": "ListItem",
                "position": 2,
                "name": "Melbourne Streetwear",
                "item": "<?php echo e(route('city.melbourne')); ?>"
            }
        ]
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/city-pages/melbourne.blade.php ENDPATH**/ ?>