<!-- resources/views/admin/products/index.blade.php -->


<?php $__env->startSection('title', 'Products'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Products</h1>
    <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Add New Product
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th style="width:80px;">Image</th>
                        <th>Name</th>
                        <th>Category</th>
                        <th style="width:120px;">Price</th>
                        <th>Featured</th>
                        <th>Status</th>
                        <th style="width:90px;">Views</th>
                        <th style="width:220px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php if($product->featured_image): ?>
                                <img src="<?php echo e(asset('storage/' . $product->featured_image)); ?>" alt="<?php echo e($product->name); ?>" width="50" height="50" class="rounded" style="object-fit:cover;">
                            <?php else: ?>
                                <div class="bg-light text-center text-muted rounded" style="width:50px;height:50px;display:flex;align-items:center;justify-content:center;">
                                    N/A
                                </div>
                            <?php endif; ?>
                        </td>

                        <td><?php echo e($product->name); ?></td>

                        <td><?php echo e(optional($product->category)->name ?? '—'); ?></td>

                        <td>
                            <?php if(!is_null($product->price)): ?>
                                $<?php echo e(number_format($product->price, 2)); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>

                        <td>
                            <span class="badge bg-<?php echo e($product->is_featured ? 'success' : 'secondary'); ?>">
                                <?php echo e($product->is_featured ? 'Yes' : 'No'); ?>

                            </span>
                        </td>

                        <td>
                            <span class="badge bg-<?php echo e($product->is_active ? 'success' : 'danger'); ?>">
                                <?php echo e($product->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>

                        <td><?php echo e($product->views ?? 0); ?></td>

                        <td>
                            <!-- public storefront view: use the shop.product route (your public route group uses shop.product) -->
                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" target="_blank" class="btn btn-sm btn-info" title="View on store">
                                <i class="fas fa-eye"></i>
                            </a>

                            <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>

                            <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this product?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center">No products found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3 d-flex justify-content-between align-items-center">
            <div class="text-muted">
                Showing <?php echo e($products->firstItem() ?? 0); ?> - <?php echo e($products->lastItem() ?? 0); ?> of <?php echo e($products->total() ?? 0); ?>

            </div>
            <div>
                <?php echo e($products->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/products/index.blade.php ENDPATH**/ ?>