<?php $__env->startSection('title', 'Edit Community Page'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Edit Community Page</h1>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('admin.community-pages.show', $communityPage)); ?>" class="btn btn-outline-info">
            <i class="fas fa-eye me-2"></i>View Page
        </a>
        <a href="<?php echo e(route('admin.community-pages.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Back to Pages
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Page Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.community-pages.update', $communityPage)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="page_key" class="form-label">Page Key <span class="text-danger">*</span></label>
                            <input type="text" id="page_key" name="page_key" class="form-control <?php $__errorArgs = ['page_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('page_key', $communityPage->page_key)); ?>" placeholder="e.g., community-gallery" required>
                            <div class="form-text">Unique identifier for the page (lowercase, use hyphens)</div>
                            <?php $__errorArgs = ['page_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                            <input type="text" id="title" name="title" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('title', $communityPage->title)); ?>" placeholder="Community Gallery" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Page Content</label>
                        <textarea id="content" name="content" class="form-control <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  rows="10" placeholder="Enter page content..."><?php echo e(old('content', $communityPage->content)); ?></textarea>
                        <div class="form-text">You can use HTML in the content</div>
                        <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Current Images -->
                    <?php if($communityPage->images && count($communityPage->images) > 0): ?>
                    <div class="mb-3">
                        <label class="form-label">Current Images</label>
                        <div class="row g-3">
                            <?php $__currentLoopData = $communityPage->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4">
                                <div class="card">
                                    <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($image)); ?>" class="card-img-top" style="height: 150px; object-fit: cover;">
                                    <div class="card-body p-2">
                                        <div class="form-check">
                                            <input type="checkbox" name="remove_images[]" value="<?php echo e($image); ?>" 
                                                   id="remove_<?php echo e($index); ?>" class="form-check-input">
                                            <label for="remove_<?php echo e($index); ?>" class="form-check-label small text-danger">
                                                Remove this image
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label for="images" class="form-label">Add New Images</label>
                        <input type="file" id="images" name="images[]" class="form-control <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               multiple accept="image/*">
                        <div class="form-text">Upload additional images (JPEG, PNG, JPG, GIF - max 10MB each)</div>
                        <?php $__errorArgs = ['images.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" id="is_active" name="is_active" class="form-check-input" value="1" 
                                   <?php echo e(old('is_active', $communityPage->is_active) ? 'checked' : ''); ?>>
                            <label for="is_active" class="form-check-label">Active</label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="<?php echo e(route('admin.community-pages.index')); ?>" class="btn btn-secondary">Cancel</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Page
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">SEO Settings</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="meta_title" class="form-label">Meta Title</label>
                    <input type="text" id="meta_title" name="meta_title" class="form-control <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           value="<?php echo e(old('meta_title', $communityPage->meta_title)); ?>" placeholder="SEO optimized title">
                    <div class="form-text">Recommended: 50-60 characters</div>
                    <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-3">
                    <label for="meta_description" class="form-label">Meta Description</label>
                    <textarea id="meta_description" name="meta_description" class="form-control <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                              rows="4" placeholder="SEO description"><?php echo e(old('meta_description', $communityPage->meta_description)); ?></textarea>
                    <div class="form-text">Recommended: 150-160 characters</div>
                    <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Page Info</h5>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between mb-2">
                    <span class="text-muted">Created:</span>
                    <span><?php echo e($communityPage->created_at->format('M d, Y g:i A')); ?></span>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span class="text-muted">Last Updated:</span>
                    <span><?php echo e($communityPage->updated_at->format('M d, Y g:i A')); ?></span>
                </div>
                <div class="d-flex justify-content-between">
                    <span class="text-muted">Images:</span>
                    <span class="badge bg-info"><?php echo e(count($communityPage->images ?? [])); ?></span>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Help</h5>
            </div>
            <div class="card-body">
                <h6>Image Management:</h6>
                <p class="small text-muted">
                    All images are processed through ImageHelper.php for optimized loading. 
                    Check the boxes above to remove existing images. New images will be added to the collection.
                </p>

                <h6>Usage in Frontend:</h6>
                <p class="small text-muted">
                    Use <code><?php echo e("\\App\\Helpers\\ImageHelper::getImageUrl(\$imagePath)"); ?></code> 
                    to display images with proper hosting compatibility.
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Character counters for SEO fields
const metaTitleField = document.getElementById('meta_title');
const metaDescField = document.getElementById('meta_description');

if (metaTitleField) {
    metaTitleField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/60 characters`;
        helpText.className = length > 60 ? 'form-text text-warning' : 'form-text';
    });
}

if (metaDescField) {
    metaDescField.addEventListener('input', function() {
        const length = this.value.length;
        const helpText = this.nextElementSibling;
        helpText.textContent = `${length}/160 characters`;
        helpText.className = length > 160 ? 'form-text text-warning' : 'form-text';
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio6\resources\views/admin/community-pages/edit.blade.php ENDPATH**/ ?>