<?php $__env->startSection('title', $guide['meta_title']); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="<?php echo e($guide['meta_description']); ?>">
<meta name="keywords" content="<?php echo e($guide['keywords']); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="city-hero py-5" style="background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo e(asset('images/' . $guide['hero_image'])); ?>'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="city-intro text-white">
                    <div class="city-meta mb-3">
                        <span class="badge bg-primary me-2"><?php echo e($guide['region']); ?></span>
                        <span class="badge bg-light text-dark"><?php echo e($guide['climate']); ?></span>
                    </div>
                    <h1 class="display-3 fw-bold mb-4"><?php echo e($guide['name']); ?></h1>
                    <p class="lead mb-4"><?php echo e($guide['tagline']); ?></p>
                    <p class="mb-4"><?php echo e($guide['description']); ?></p>
                    <div class="city-stats d-flex gap-4">
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0"><?php echo e($guide['population']); ?></div>
                            <small>Population</small>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0"><?php echo e($guide['fashion_score']); ?>/10</div>
                            <small>Fashion Scene</small>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number h5 mb-0"><?php echo e($guide['streetwear_popularity']); ?>%</div>
                            <small>Streetwear Pop.</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Style Breakdown -->
<section class="style-breakdown py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <h2 class="mb-4">The <?php echo e($guide['name']); ?> Style DNA</h2>
                <div class="style-characteristics mb-5">
                    <?php $__currentLoopData = $guide['style_characteristics']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $characteristic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="characteristic-item mb-4 p-4 bg-light rounded">
                            <h5 class="text-primary mb-2"><?php echo e($characteristic['title']); ?></h5>
                            <p class="mb-0"><?php echo e($characteristic['description']); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Key Pieces -->
                <div class="key-pieces mb-5">
                    <h3 class="mb-4">Essential <?php echo e($guide['name']); ?> Pieces</h3>
                    <div class="row g-3">
                        <?php $__currentLoopData = $guide['key_pieces']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <div class="piece-item d-flex align-items-center p-3 bg-white border rounded">
                                    <div class="piece-icon me-3">
                                        <i class="fas fa-tshirt text-primary fa-lg"></i>
                                    </div>
                                    <div class="piece-info">
                                        <h6 class="mb-1"><?php echo e($piece); ?></h6>
                                        <small class="text-muted">Perfect for <?php echo e(strtolower($guide['name'])); ?> lifestyle</small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Seasonal Styling -->
                <div class="seasonal-styling mb-5">
                    <h3 class="mb-4">Year-Round <?php echo e($guide['name']); ?> Styling</h3>
                    <div class="seasons-grid">
                        <?php $__currentLoopData = $guide['seasonal_styling']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $season => $styling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="season-card mb-4 p-4 border rounded">
                                <h5 class="season-title mb-3">
                                    <i class="fas fa-<?php echo e($styling['icon']); ?> text-primary me-2"></i>
                                    <?php echo e($styling['season']); ?>

                                </h5>
                                <p class="season-description mb-3"><?php echo e($styling['description']); ?></p>
                                <div class="season-tips">
                                    <h6 class="mb-2">Key Tips:</h6>
                                    <ul class="mb-0">
                                        <?php $__currentLoopData = $styling['tips']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($tip); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Local Influences -->
                <div class="local-influences mb-5">
                    <h3 class="mb-4"><?php echo e($guide['name']); ?> Cultural Influences</h3>
                    <div class="influences-grid">
                        <?php $__currentLoopData = $guide['cultural_influences']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $influence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="influence-item mb-3 p-4 bg-gradient-light rounded">
                                <h6 class="fw-bold mb-2"><?php echo e($influence['aspect']); ?></h6>
                                <p class="mb-0"><?php echo e($influence['description']); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="city-sidebar">
                    <!-- Color Palette -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo e($guide['name']); ?> Color Palette</h5>
                            <div class="color-palette mb-3">
                                <div class="row g-2">
                                    <?php $__currentLoopData = $guide['color_palette']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-6 text-center">
                                            <div class="color-swatch mx-auto mb-2 rounded-circle" 
                                                 style="width: 50px; height: 50px; background-color: <?php echo e($color['hex']); ?>;"></div>
                                            <small class="d-block"><?php echo e($color['name']); ?></small>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <small class="text-muted">These colors reflect <?php echo e(strtolower($guide['name'])); ?>'s natural beauty and urban energy.</small>
                        </div>
                    </div>

                    <!-- Best Shopping Areas -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Best Shopping Areas</h5>
                            <ul class="list-unstyled mb-0">
                                <?php $__currentLoopData = $guide['shopping_areas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="mb-2">
                                        <i class="fas fa-map-marker-alt text-primary me-2"></i>
                                        <strong><?php echo e($area['name']); ?></strong>
                                        <small class="d-block text-muted ms-3"><?php echo e($area['description']); ?></small>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <!-- Weather Considerations -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Weather & Style</h5>
                            <div class="weather-info">
                                <div class="weather-stat mb-2">
                                    <strong>Average Temperature:</strong> <?php echo e($guide['weather']['avg_temp']); ?>

                                </div>
                                <div class="weather-stat mb-2">
                                    <strong>Rainfall:</strong> <?php echo e($guide['weather']['rainfall']); ?>

                                </div>
                                <div class="weather-stat mb-3">
                                    <strong>Best Months:</strong> <?php echo e($guide['weather']['best_months']); ?>

                                </div>
                                <small class="text-muted"><?php echo e($guide['weather']['style_note']); ?></small>
                            </div>
                        </div>
                    </div>

                    <!-- Call to Action -->
                    <div class="card">
                        <div class="card-body text-center">
                            <h5 class="card-title">Shop <?php echo e($guide['name']); ?> Style</h5>
                            <p class="card-text">Get the perfect pieces for <?php echo e(strtolower($guide['name'])); ?> streetwear.</p>
                            <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary w-100 mb-2">
                                Shop Collection
                            </a>
                            <a href="<?php echo e(route('community.submit')); ?>" class="btn btn-outline-primary w-100">
                                Share Your Look
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Style Gallery -->
<section class="style-gallery py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center"><?php echo e($guide['name']); ?> Street Style Inspiration</h3>
                <div class="row g-4">
                    <?php $__currentLoopData = $guide['style_gallery']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $look): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 col-sm-6">
                            <div class="gallery-item position-relative">
                                <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($look['image']).'','alt' => ''.e($look['description']).'','class' => 'img-fluid rounded','style' => 'height: 300px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                <div class="gallery-overlay position-absolute bottom-0 start-0 end-0 p-3 text-white">
                                    <small class="d-block opacity-90"><?php echo e($look['description']); ?></small>
                                    <span class="badge bg-primary"><?php echo e($look['style_type']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Related Cities -->
<section class="related-cities py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="mb-4 text-center">Explore Other Australian Cities</h3>
                <div class="row g-4">
                    <?php $__currentLoopData = $relatedCities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $citySlug => $relatedCity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="related-city-card h-100 bg-white rounded shadow-sm">
                                <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($relatedCity['image']).'','alt' => ''.e($relatedCity['name']).' Style Guide','class' => 'card-img-top rounded-top','style' => 'height: 200px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo e($relatedCity['name']); ?></h5>
                                    <p class="card-text"><?php echo e($relatedCity['description']); ?></p>
                                    <a href="<?php echo e(route('style-guide.show', $citySlug)); ?>" class="btn btn-outline-primary">
                                        Explore Style Guide
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .city-hero {
        min-height: 600px;
        display: flex;
        align-items: center;
    }
    
    .characteristic-item {
        border-left: 4px solid #007bff;
    }
    
    .piece-item {
        transition: transform 0.2s ease;
    }
    
    .piece-item:hover {
        transform: translateX(5px);
    }
    
    .season-card {
        transition: box-shadow 0.3s ease;
    }
    
    .season-card:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .color-swatch {
        border: 3px solid #fff;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    
    .gallery-item {
        border-radius: 0.5rem;
        overflow: hidden;
        transition: transform 0.3s ease;
    }
    
    .gallery-item:hover {
        transform: scale(1.05);
    }
    
    .gallery-overlay {
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
    }
    
    .bg-gradient-light {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .related-city-card {
        transition: transform 0.3s ease;
    }
    
    .related-city-card:hover {
        transform: translateY(-5px);
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Article",
    "headline": "<?php echo e($guide['name']); ?> Street Style Guide",
    "description": "<?php echo e($guide['description']); ?>",
    "image": "<?php echo e(asset('images/' . $guide['hero_image'])); ?>",
    "author": {
        "@type": "Organization",
        "name": "Edition By Punjab"
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    },
    "datePublished": "<?php echo e(now()->toISOString()); ?>",
    "dateModified": "<?php echo e(now()->toISOString()); ?>",
    "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "<?php echo e(route('style-guide.show', $city)); ?>"
    },
    "about": {
        "@type": "Place",
        "name": "<?php echo e($guide['name']); ?>",
        "description": "<?php echo e($guide['description']); ?>"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/style-guide/show.blade.php ENDPATH**/ ?>